/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.AbstractGUI;
import cn.superiormc.ultimateshop.listeners.GUIListener;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.utils.PacketInventoryUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class InvGUI
extends AbstractGUI {
    protected Inventory inv;
    public Map<Integer, AbstractButton> menuButtons = new HashMap<Integer, AbstractButton>();
    public Map<Integer, ItemStack> menuItems = new HashMap<Integer, ItemStack>();
    public Listener guiListener;
    protected BukkitRunnable runTask = null;
    public String title;

    public InvGUI(Player owner) {
        super(owner);
    }

    public boolean getChangeable() {
        return false;
    }

    public abstract boolean clickEventHandle(Inventory var1, ClickType var2, int var3);

    public boolean closeEventHandle(Inventory inventory) {
        if (this.runTask != null) {
            this.runTask.cancel();
        }
        return true;
    }

    public boolean dragEventHandle(Map<Integer, ItemStack> newItems) {
        return true;
    }

    public void afterClickEventHandle(ItemStack item, ItemStack currentItem, int slot) {
    }

    public void openGUI(boolean reopen) {
        if (!super.canOpenGUI(reopen)) {
            return;
        }
        this.constructGUI();
        if (this.inv != null) {
            this.player.openInventory(this.inv);
            this.guiListener = new GUIListener(this);
            Bukkit.getPluginManager().registerEvents(this.guiListener, (Plugin)UltimateShop.instance);
            if (this.getMenu() != null) {
                this.getMenu().doOpenAction(this.player, reopen);
            }
        }
        if (ConfigManager.configManager.getBooleanOrDefault("menu.shop.update", "menu.menu-update.circle-update") || ConfigManager.configManager.getBoolean("menu.title-update.circle-update")) {
            this.runTask = new BukkitRunnable(){

                public void run() {
                    if (ConfigManager.configManager.getBooleanOrDefault("menu.shop.update", "menu.menu-update.circle-update")) {
                        InvGUI.this.constructGUI();
                    }
                    if (ConfigManager.configManager.getBoolean("menu.title-update.circle-update") && UltimateShop.usePacketEvents) {
                        PacketInventoryUtil.packetInventoryUtil.updateTitle(InvGUI.this.player, InvGUI.this);
                    }
                }
            };
            this.runTask.runTaskTimer((Plugin)UltimateShop.instance, 20L, 20L);
        }
    }

    public Inventory getInv() {
        return this.inv;
    }

    public Map<Integer, ItemStack> getMenuItems(Player player) {
        Map<Integer, AbstractButton> tempVal1 = this.menuButtons;
        HashMap<Integer, ItemStack> resultItems = new HashMap<Integer, ItemStack>();
        for (int i : tempVal1.keySet()) {
            resultItems.put(i, tempVal1.get(i).getDisplayItem(player, 1).getItemStack());
        }
        return resultItems;
    }

    public ItemStack getMenuItem(Player player, int slot) {
        Map<Integer, AbstractButton> tempVal1 = this.menuButtons;
        AbstractButton button = tempVal1.get(slot);
        if (button == null) {
            return new ItemStack(Material.AIR);
        }
        return button.getDisplayItem(player, 1).getItemStack();
    }
}

