/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database.sql;

import cn.superiormc.ultimateshop.database.sql.DatabaseDialect;

public class SQLiteDialect
extends DatabaseDialect {
    @Override
    public boolean matches(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:sqlite:");
    }

    @Override
    public String dateTimeType() {
        return "TEXT";
    }

    @Override
    public int maxPoolSize() {
        return 1;
    }

    @Override
    public int minIdle() {
        return 1;
    }

    @Override
    public boolean forceSingleConnection() {
        return true;
    }

    @Override
    public boolean supportBatch() {
        return false;
    }

    @Override
    public String createUseTimesTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_useTimes (\n        playerUUID TEXT NOT NULL,\n        shop TEXT NOT NULL,\n        product TEXT NOT NULL,\n        buyUseTimes INTEGER DEFAULT 0,\n        totalBuyUseTimes INTEGER DEFAULT 0,\n        sellUseTimes INTEGER DEFAULT 0,\n        totalSellUseTimes INTEGER DEFAULT 0,\n        lastBuyTime TEXT,\n        lastSellTime TEXT,\n        lastResetBuyTime TEXT,\n        lastResetSellTime TEXT,\n        cooldownBuyTime TEXT,\n        cooldownSellTime TEXT,\n        PRIMARY KEY (playerUUID, shop, product)\n    )\n";
    }

    @Override
    public String createRandomPlaceholderTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_randomPlaceholders (\n        playerUUID TEXT NOT NULL,\n        placeholderID TEXT NOT NULL,\n        nowValue TEXT,\n        refreshDoneTime TEXT,\n        PRIMARY KEY (playerUUID, placeholderID)\n    )\n";
    }

    @Override
    public String upsertUseTimes() {
        return "    INSERT INTO ultimateshop_useTimes (\n        playerUUID, shop, product,\n        buyUseTimes, totalBuyUseTimes,\n        sellUseTimes, totalSellUseTimes,\n        lastBuyTime, lastSellTime,\n        lastResetBuyTime, lastResetSellTime,\n        cooldownBuyTime, cooldownSellTime\n    )\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT(playerUUID, shop, product)\n    DO UPDATE SET\n        buyUseTimes = excluded.buyUseTimes,\n        totalBuyUseTimes = excluded.totalBuyUseTimes,\n        sellUseTimes = excluded.sellUseTimes,\n        totalSellUseTimes = excluded.totalSellUseTimes,\n        lastBuyTime = excluded.lastBuyTime,\n        lastSellTime = excluded.lastSellTime,\n        lastResetBuyTime = excluded.lastResetBuyTime,\n        lastResetSellTime = excluded.lastResetSellTime,\n        cooldownBuyTime = excluded.cooldownBuyTime,\n        cooldownSellTime = excluded.cooldownSellTime\n";
    }

    @Override
    public String upsertRandomPlaceholder() {
        return "    INSERT INTO ultimateshop_randomPlaceholders (\n        playerUUID, placeholderID,\n        nowValue, refreshDoneTime\n    )\n    VALUES (?, ?, ?, ?)\n    ON CONFLICT(playerUUID, placeholderID)\n    DO UPDATE SET\n        nowValue = excluded.nowValue,\n        refreshDoneTime = excluded.refreshDoneTime\n";
    }

    @Override
    public void needExtraDownload(String jdbcUrl) {
    }
}

