/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database.sql;

import cn.superiormc.ultimateshop.database.sql.DatabaseDialect;

public class PostgreSQLDialect
extends DatabaseDialect {
    @Override
    public boolean matches(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:postgresql:");
    }

    @Override
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public int maxPoolSize() {
        return 10;
    }

    @Override
    public int minIdle() {
        return 2;
    }

    @Override
    public String createUseTimesTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_useTimes (\n        playerUUID VARCHAR(36) NOT NULL,\n        shop VARCHAR(48) NOT NULL,\n        product VARCHAR(48) NOT NULL,\n        buyUseTimes INT DEFAULT 0,\n        totalBuyUseTimes INT DEFAULT 0,\n        sellUseTimes INT DEFAULT 0,\n        totalSellUseTimes INT DEFAULT 0,\n        lastBuyTime TIMESTAMP,\n        lastSellTime TIMESTAMP,\n        lastResetBuyTime TIMESTAMP,\n        lastResetSellTime TIMESTAMP,\n        cooldownBuyTime TIMESTAMP,\n        cooldownSellTime TIMESTAMP,\n        PRIMARY KEY (playerUUID, shop, product)\n    )\n";
    }

    @Override
    public String createRandomPlaceholderTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_randomPlaceholders (\n        playerUUID VARCHAR(36) NOT NULL,\n        placeholderID VARCHAR(48) NOT NULL,\n        nowValue TEXT,\n        refreshDoneTime TIMESTAMP,\n        PRIMARY KEY (playerUUID, placeholderID)\n    )\n";
    }

    @Override
    public String upsertUseTimes() {
        return "    INSERT INTO ultimateshop_useTimes (\n        playerUUID, shop, product,\n        buyUseTimes, totalBuyUseTimes,\n        sellUseTimes, totalSellUseTimes,\n        lastBuyTime, lastSellTime,\n        lastResetBuyTime, lastResetSellTime,\n        cooldownBuyTime, cooldownSellTime\n    )\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (playerUUID, shop, product)\n    DO UPDATE SET\n        buyUseTimes = EXCLUDED.buyUseTimes,\n        totalBuyUseTimes = EXCLUDED.totalBuyUseTimes,\n        sellUseTimes = EXCLUDED.sellUseTimes,\n        totalSellUseTimes = EXCLUDED.totalSellUseTimes,\n        lastBuyTime = EXCLUDED.lastBuyTime,\n        lastSellTime = EXCLUDED.lastSellTime,\n        lastResetBuyTime = EXCLUDED.lastResetBuyTime,\n        lastResetSellTime = EXCLUDED.lastResetSellTime,\n        cooldownBuyTime = EXCLUDED.cooldownBuyTime,\n        cooldownSellTime = EXCLUDED.cooldownSellTime\n";
    }

    @Override
    public String upsertRandomPlaceholder() {
        return "    INSERT INTO ultimateshop_randomPlaceholders (\n        playerUUID, placeholderID,\n        nowValue, refreshDoneTime\n    )\n    VALUES (?, ?, ?, ?)\n    ON CONFLICT (playerUUID, placeholderID)\n    DO UPDATE SET\n        nowValue = EXCLUDED.nowValue,\n        refreshDoneTime = EXCLUDED.refreshDoneTime\n";
    }

    @Override
    public void needExtraDownload(String jdbcUrl) {
        this.loadDriver("postgresql", "https://repo1.maven.org/maven2/org/postgresql/postgresql/42.6.0/postgresql-42.6.0.jar", "org.postgresql.Driver");
    }
}

