/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database.sql;

import cn.superiormc.ultimateshop.database.sql.DatabaseDialect;

public class MySQLDialect
extends DatabaseDialect {
    @Override
    public boolean matches(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:mysql:") || jdbcUrl.startsWith("jdbc:mariadb:");
    }

    @Override
    public String dateTimeType() {
        return "DATETIME";
    }

    @Override
    public int maxPoolSize() {
        return 10;
    }

    @Override
    public int minIdle() {
        return 2;
    }

    @Override
    public String createUseTimesTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_useTimes (\n        playerUUID VARCHAR(36) NOT NULL,\n        shop VARCHAR(48) NOT NULL,\n        product VARCHAR(48) NOT NULL,\n        buyUseTimes INT DEFAULT 0,\n        totalBuyUseTimes INT DEFAULT 0,\n        sellUseTimes INT DEFAULT 0,\n        totalSellUseTimes INT DEFAULT 0,\n        lastBuyTime DATETIME NULL,\n        lastSellTime DATETIME NULL,\n        lastResetBuyTime DATETIME NULL,\n        lastResetSellTime DATETIME NULL,\n        cooldownBuyTime DATETIME NULL,\n        cooldownSellTime DATETIME NULL,\n        PRIMARY KEY (playerUUID, shop, product)\n    )\n";
    }

    @Override
    public String createRandomPlaceholderTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_randomPlaceholders (\n        playerUUID VARCHAR(36) NOT NULL,\n        placeholderID VARCHAR(48) NOT NULL,\n        nowValue TEXT,\n        refreshDoneTime DATETIME,\n        PRIMARY KEY (playerUUID, placeholderID)\n    )\n";
    }

    @Override
    public String upsertUseTimes() {
        return "    INSERT INTO ultimateshop_useTimes\n    (playerUUID, shop, product, buyUseTimes, totalBuyUseTimes, sellUseTimes, totalSellUseTimes,\n     lastBuyTime, lastSellTime, lastResetBuyTime, lastResetSellTime, cooldownBuyTime, cooldownSellTime)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        buyUseTimes = VALUES(buyUseTimes),\n        totalBuyUseTimes = VALUES(totalBuyUseTimes),\n        sellUseTimes = VALUES(sellUseTimes),\n        totalSellUseTimes = VALUES(totalSellUseTimes),\n        lastBuyTime = VALUES(lastBuyTime),\n        lastSellTime = VALUES(lastSellTime),\n        lastResetBuyTime = VALUES(lastResetBuyTime),\n        lastResetSellTime = VALUES(lastResetSellTime),\n        cooldownBuyTime = VALUES(cooldownBuyTime),\n        cooldownSellTime = VALUES(cooldownSellTime)\n";
    }

    @Override
    public String upsertRandomPlaceholder() {
        return "    INSERT INTO ultimateshop_randomPlaceholders\n    (playerUUID, placeholderID, nowValue, refreshDoneTime)\n    VALUES (?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        nowValue = VALUES(nowValue),\n        refreshDoneTime = VALUES(refreshDoneTime)\n";
    }

    @Override
    public void needExtraDownload(String jdbcUrl) {
        if (jdbcUrl.startsWith("jdbc:mariadb:")) {
            this.loadDriver("mariadb-java-client", "https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.1.6/mariadb-java-client-3.1.6.jar", "org.mariadb.jdbc.Driver");
        }
    }
}

