/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database.sql;

import cn.superiormc.ultimateshop.database.sql.DatabaseDialect;

public class H2Dialect
extends DatabaseDialect {
    @Override
    public boolean matches(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:h2:");
    }

    @Override
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public int maxPoolSize() {
        return 5;
    }

    @Override
    public int minIdle() {
        return 1;
    }

    @Override
    public String createUseTimesTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_useTimes (\n        playerUUID VARCHAR(36) NOT NULL,\n        shop VARCHAR(48) NOT NULL,\n        product VARCHAR(48) NOT NULL,\n        buyUseTimes INT DEFAULT 0,\n        totalBuyUseTimes INT DEFAULT 0,\n        sellUseTimes INT DEFAULT 0,\n        totalSellUseTimes INT DEFAULT 0,\n        lastBuyTime TIMESTAMP,\n        lastSellTime TIMESTAMP,\n        lastResetBuyTime TIMESTAMP,\n        lastResetSellTime TIMESTAMP,\n        cooldownBuyTime TIMESTAMP,\n        cooldownSellTime TIMESTAMP,\n        PRIMARY KEY (playerUUID, shop, product)\n    )\n";
    }

    @Override
    public String createRandomPlaceholderTable() {
        return "    CREATE TABLE IF NOT EXISTS ultimateshop_randomPlaceholders (\n        playerUUID VARCHAR(36) NOT NULL,\n        placeholderID VARCHAR(48) NOT NULL,\n        nowValue TEXT,\n        refreshDoneTime TIMESTAMP,\n        PRIMARY KEY (playerUUID, placeholderID)\n    )\n";
    }

    @Override
    public String upsertUseTimes() {
        return "    MERGE INTO ultimateshop_useTimes\n    (playerUUID, shop, product,\n     buyUseTimes, totalBuyUseTimes,\n     sellUseTimes, totalSellUseTimes,\n     lastBuyTime, lastSellTime,\n     lastResetBuyTime, lastResetSellTime,\n     cooldownBuyTime, cooldownSellTime)\n    KEY (playerUUID, shop, product)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    }

    @Override
    public String upsertRandomPlaceholder() {
        return "    MERGE INTO ultimateshop_randomPlaceholders\n    (playerUUID, placeholderID,\n     nowValue, refreshDoneTime)\n    KEY (playerUUID, placeholderID)\n    VALUES (?, ?, ?, ?)\n";
    }

    @Override
    public void needExtraDownload(String jdbcUrl) {
        this.loadDriver("h2", "https://repo1.maven.org/maven2/com/h2database/h2/2.2.220/h2-2.2.220.jar", "org.h2.Driver");
    }
}

