/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database.sql;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.database.DriverShim;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Driver;
import java.sql.DriverManager;

public abstract class DatabaseDialect {
    public abstract boolean matches(String var1);

    public abstract String dateTimeType();

    public abstract int maxPoolSize();

    public abstract int minIdle();

    public abstract String createUseTimesTable();

    public abstract String createRandomPlaceholderTable();

    public abstract String upsertUseTimes();

    public abstract String upsertRandomPlaceholder();

    public boolean supportBatch() {
        return true;
    }

    public boolean forceSingleConnection() {
        return false;
    }

    public abstract void needExtraDownload(String var1);

    public void loadDriver(String driverName, String mavenUrl, String driverClassName) {
        try {
            String jarName;
            Path jarPath;
            Path libPath = Paths.get("plugins/UltimateShop/libs/", new String[0]);
            if (!Files.exists(libPath, new LinkOption[0])) {
                Files.createDirectories(libPath, new FileAttribute[0]);
            }
            if (!Files.exists(jarPath = libPath.resolve(jarName = driverName + ".jar"), new LinkOption[0])) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fDownloading " + jarName + " ...");
                try (InputStream in = new URL(mavenUrl).openStream();){
                    Files.copy(in, jarPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            URL jarUrl = jarPath.toUri().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{jarUrl}, ((Object)((Object)UltimateShop.instance)).getClass().getClassLoader());
            Class<?> driverClass = Class.forName(driverClassName, true, loader);
            Driver driverInstance = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(new DriverShim(driverInstance));
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7f" + driverName + " loaded!");
        }
        catch (Throwable e) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fFailed to load " + driverName + "!");
            e.printStackTrace();
        }
    }
}

