/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.database.AbstractDatabase;
import cn.superiormc.ultimateshop.database.DatabaseExecutor;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.caches.ObjectCache;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDatabase
extends AbstractDatabase {
    private final File dataDir = new File(UltimateShop.instance.getDataFolder(), "datas");

    @Override
    public void checkData(ObjectCache cache) {
        CompletableFuture.runAsync(() -> this.loadData(cache), DatabaseExecutor.EXECUTOR);
    }

    private void loadData(ObjectCache cache) {
        YamlConfiguration config;
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        File file = cache.isServer() ? new File(this.dataDir, "global.yml") : new File(this.dataDir, String.valueOf(cache.getPlayer().getUniqueId()) + ".yml");
        try {
            if (!file.exists()) {
                config = new YamlConfiguration();
                config.set("playerName", (Object)(cache.isServer() ? "global" : cache.getPlayer().getName()));
                config.save(file);
            }
        }
        catch (IOException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not create new data file: " + file.getName() + "!");
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection useTimeSection = config.getConfigurationSection("useTimes");
        if (useTimeSection != null) {
            useTimeSection.getKeys(false).forEach(shopID -> {
                ConfigurationSection shopSection = useTimeSection.getConfigurationSection(shopID);
                if (shopSection == null) {
                    return;
                }
                shopSection.getKeys(false).forEach(productID -> {
                    ConfigurationSection productSection = shopSection.getConfigurationSection(productID);
                    if (productSection == null) {
                        return;
                    }
                    String lastBuy = productSection.getString("lastBuyTime", null);
                    String lastSell = productSection.getString("lastSellTime", null);
                    String lastResetBuy = productSection.getString("lastResetBuyTime", null);
                    String lastResetSell = productSection.getString("lastResetSellTime", null);
                    String cooldownBuy = productSection.getString("cooldownBuyTime", null);
                    String cooldownSell = productSection.getString("cooldownSellTime", null);
                    int buyUseTimes = productSection.getInt("buyUseTimes", 0);
                    int totalBuyUseTimes = productSection.getInt("totalBuyUseTimes", 0);
                    int sellUseTimes = productSection.getInt("sellUseTimes", 0);
                    int totalSellUseTimes = productSection.getInt("totalSellUseTimes", 0);
                    cache.setUseTimesCache((String)shopID, (String)productID, buyUseTimes, totalBuyUseTimes, sellUseTimes, totalSellUseTimes, lastBuy, lastSell, lastResetBuy, lastResetSell, cooldownBuy, cooldownSell);
                });
            });
        }
    }

    @Override
    public void updateData(ObjectCache cache, boolean quitServer) {
        CompletableFuture.runAsync(() -> {
            this.saveData(cache);
            if (quitServer) {
                CacheManager.cacheManager.removeObjectCache(cache.getPlayer());
            }
        }, DatabaseExecutor.EXECUTOR);
    }

    private void saveData(ObjectCache cache) {
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        File file = cache.isServer() ? new File(this.dataDir, "global.yml") : new File(this.dataDir, String.valueOf(cache.getPlayer().getUniqueId()) + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        ConfigurationSection useTimesSection = config.createSection("useTimes");
        cache.getUseTimesCache().forEach((item, c) -> {
            ConfigurationSection productSection;
            ConfigurationSection shopSection = useTimesSection.getConfigurationSection(item.getShop());
            if (shopSection == null) {
                shopSection = useTimesSection.createSection(item.getShop());
            }
            if ((productSection = shopSection.getConfigurationSection(item.getProduct())) == null) {
                productSection = shopSection.createSection(item.getProduct());
            }
            if (c.getBuyUseTimes() != 0) {
                productSection.set("buyUseTimes", (Object)c.getBuyUseTimes());
            }
            if (c.getTotalBuyUseTimes() != 0) {
                productSection.set("totalBuyUseTimes", (Object)c.getTotalBuyUseTimes());
            }
            if (c.getSellUseTimes() != 0) {
                productSection.set("sellUseTimes", (Object)c.getSellUseTimes());
            }
            if (c.getTotalSellUseTimes() != 0) {
                productSection.set("totalSellUseTimes", (Object)c.getTotalSellUseTimes());
            }
            if (c.getLastBuyTime() != null) {
                productSection.set("lastBuyTime", (Object)c.getLastBuyTime());
            }
            if (c.getLastSellTime() != null) {
                productSection.set("lastSellTime", (Object)c.getLastSellTime());
            }
            if (c.getLastResetBuyTime() != null) {
                productSection.set("lastResetBuyTime", (Object)c.getLastResetBuyTime());
            }
            if (c.getLastResetSellTime() != null) {
                productSection.set("lastResetSellTime", (Object)c.getLastResetSellTime());
            }
            if (c.getCooldownBuyTime() != null) {
                productSection.set("cooldownBuyTime", (Object)c.getCooldownBuyTime());
            }
            if (c.getCooldownSellTime() != null) {
                productSection.set("cooldownSellTime", (Object)c.getCooldownSellTime());
            }
        });
        try {
            config.save(file);
        }
        catch (IOException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not save data file: " + file.getName() + "!");
        }
    }

    @Override
    public void updateDataOnDisable(ObjectCache cache, boolean disable) {
        this.saveData(cache);
        CacheManager.cacheManager.removeObjectCache(cache.getPlayer());
    }

    private static /* synthetic */ void lambda$loadData$3(ConfigurationSection randomSection, ObjectCache cache, String phID) {
        ConfigurationSection phSection = randomSection.getConfigurationSection(phID);
        if (phSection == null) {
            return;
        }
        String nowValue = phSection.getString("nowValue", null);
        String refreshDoneTime = phSection.getString("refreshDoneTime", null);
        if (nowValue != null && refreshDoneTime != null) {
            cache.setRandomPlaceholderCache(phID, refreshDoneTime, CommonUtil.translateString(nowValue));
        }
    }
}

