/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro.command;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import top.ourisland.litemacro.actions.Action;
import top.ourisland.litemacro.actions.ActionFactory;
import top.ourisland.litemacro.config.model.ActionSpec;
import top.ourisland.litemacro.config.model.MacroSpec;
import top.ourisland.litemacro.runtime.I18n;
import top.ourisland.litemacro.runtime.InvocationContext;
import top.ourisland.litemacro.runtime.MacroRunner;

public class MacroCommand
implements SimpleCommand {
    private final ProxyServer server;
    private final Logger logger;
    private final MacroSpec spec;
    private final List<Action> actions;
    private final Object plugin;

    public MacroCommand(ProxyServer server, Logger logger, Object plugin, MacroSpec spec) {
        this.server = server;
        this.logger = logger;
        this.plugin = plugin;
        this.spec = spec;
        this.actions = this.buildActions(spec.getActions());
    }

    private List<Action> buildActions(List<ActionSpec> specs) {
        if (specs == null) {
            return Collections.emptyList();
        }
        return specs.stream().map(ActionFactory::fromSpec).collect(Collectors.toList());
    }

    public void execute(SimpleCommand.Invocation invocation) {
        HashMap<String, String> vars = new HashMap<String, String>();
        String[] args = (String[])invocation.arguments();
        for (int i = 0; i < args.length; ++i) {
            vars.put("arg" + i, args[i]);
        }
        InvocationContext ctx = new InvocationContext(this.server, invocation.source(), vars, this.plugin);
        if (this.actions.isEmpty()) {
            invocation.source().sendMessage(I18n.lang("litemacro.command.macro.no_actions", new Object[0]));
            return;
        }
        new MacroRunner(ctx, this.actions).start();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        String perm = this.spec.getPermission();
        return perm == null || perm.isBlank() || invocation.source().hasPermission(perm);
    }
}

