/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro.actions;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import top.ourisland.litemacro.actions.Action;
import top.ourisland.litemacro.runtime.I18n;
import top.ourisland.litemacro.runtime.InvocationContext;

public class TransferAction
implements Action {
    private final String targetName;
    private final String message;

    public TransferAction(String targetName, String message) {
        this.targetName = targetName;
        this.message = message;
    }

    @Override
    public void execute(InvocationContext ctx) {
        Optional<Player> pOpt = ctx.player();
        if (pOpt.isEmpty()) {
            ctx.source().sendMessage(I18n.lang("litemacro.action.transfer.need_player", new Object[0]));
            return;
        }
        String resolved = ctx.replacePlaceholders(this.targetName);
        Optional srvOpt = ctx.server().getServer(resolved);
        if (srvOpt.isEmpty()) {
            ctx.source().sendMessage(I18n.lang("litemacro.action.transfer.server_not_found", resolved));
            return;
        }
        Player player = pOpt.get();
        if (this.message != null && !this.message.isBlank()) {
            player.sendMessage(I18n.prefix(ctx.replacePlaceholders(this.message)));
        }
        RegisteredServer server = (RegisteredServer)srvOpt.get();
        player.createConnectionRequest(server).connect().whenComplete((result, err) -> {
            if (err != null) {
                ctx.source().sendMessage(I18n.lang("litemacro.action.transfer.failed_to_connect", err.getMessage()));
                return;
            }
            try {
                if (!"SUCCESS".equals(String.valueOf(result.getStatus()))) {
                    ctx.source().sendMessage(I18n.lang("litemacro.action.transfer.failed", result.getStatus()));
                }
            }
            catch (Throwable t) {
                ctx.source().sendMessage(I18n.lang("litemacro.action.transfer.result", result));
            }
        });
    }
}

