/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import top.ourisland.litemacro.command.MacroCommand;
import top.ourisland.litemacro.config.ConfigManager;
import top.ourisland.litemacro.config.model.MacroSpec;
import top.ourisland.litemacro.runtime.I18n;

@Plugin(id="litemacro", name="liteMacro", version="0.3.3", description="A lite-weight macro command plugin for velocity.", url="https://github.com/Our-Island/liteMacro", authors={"OurIsland", "Chiloven945"})
public class LiteMacro {
    private final Map<String, List<String>> registeredAliases = new HashMap<String, List<String>>();
    @Inject
    private Logger logger;
    @Inject
    private ProxyServer server;
    @Inject
    private CommandManager commandManager;
    @Inject
    @DataDirectory
    private Path dataDirectory;
    private ConfigManager configManager;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.logger.info("Initializing liteMarco v{}...\n{}", (Object)"0.3.3", (Object)"##\\ ##\\   ##\\               ##\\      ##\\                                         \n## |\\__|  ## |              ###\\    ### |                                        \n## |##\\ ######\\    ######\\  ####\\  #### | ######\\   #######\\  ######\\   ######\\  \n## |## |\\_##  _|  ##  __##\\ ##\\##\\## ## | \\____##\\ ##  _____|##  __##\\ ##  __##\\ \n## |## |  ## |    ######## |## \\###  ## | ####### |## /      ## |  \\__|## /  ## |\n## |## |  ## |##\\ ##   ____|## |\\#  /## |##  __## |## |      ## |      ## |  ## |\n## |## |  \\####  |\\#######\\ ## | \\_/ ## |\\####### |\\#######\\ ## |      \\######  |\n\\__|\\__|   \\____/  \\_______|\\__|     \\__| \\_______| \\_______|\\__|       \\______/ ");
            if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            this.configManager = new ConfigManager(this.logger, this.server, this.dataDirectory);
            this.configManager.loadOrCreate();
            I18n.init(this.configManager, this.logger);
            this.registerAllMacros();
            this.registerAdminCommand();
            this.logger.info("liteMarco initialized. Macros registered: {}", this.registeredAliases.keySet());
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize liteMarco", (Throwable)e);
        }
    }

    private void registerAllMacros() {
        this.unregisterAllMacros();
        Map<String, MacroSpec> macros = this.configManager.getMacros();
        if (macros.isEmpty()) {
            this.logger.warn("No macros found in command.yml");
            return;
        }
        macros.forEach(this::registerOneMacro);
    }

    private void registerAdminCommand() {
        CommandMeta meta = this.commandManager.metaBuilder("litemacro").plugin((Object)this).build();
        this.commandManager.register(meta, (Command)((SimpleCommand)invocation -> {
            if (!invocation.source().hasPermission("litemacro.admin")) {
                invocation.source().sendMessage(I18n.lang("litemacro.main.no_perms", "litemacro.admin"));
                return;
            }
            String[] args = (String[])invocation.arguments();
            if (args.length == 0 || !"reload".equalsIgnoreCase(args[0])) {
                invocation.source().sendMessage(I18n.lang("litemacro.main.usage", "/litemacro reload"));
                return;
            }
            try {
                this.unregisterAllMacros();
                this.configManager.loadOrCreate();
                String lang = this.configManager.getLang();
                I18n.loadResourceBundle(lang);
                this.registerAllMacros();
                invocation.source().sendMessage(I18n.lang("litemacro.main.reload", new Object[0]));
            }
            catch (Exception e) {
                invocation.source().sendMessage(I18n.lang("litemacro.main.reload.failed", e.getMessage()));
                this.logger.error("Reload failed", (Throwable)e);
            }
        }));
    }

    private void unregisterAllMacros() {
        if (this.registeredAliases.isEmpty()) {
            return;
        }
        for (List<String> aliases : this.registeredAliases.values()) {
            for (String a : aliases) {
                try {
                    this.commandManager.unregister(a);
                }
                catch (Throwable throwable) {}
            }
        }
        this.registeredAliases.clear();
    }

    private void registerOneMacro(String name, MacroSpec spec) {
        String primary = name.toLowerCase(Locale.ROOT);
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(primary);
        if (spec.getAliases() != null) {
            spec.getAliases().forEach(a -> aliases.add(a.toLowerCase(Locale.ROOT)));
        }
        MacroCommand command = new MacroCommand(this.server, this.logger, this, spec);
        for (String alias : aliases) {
            CommandMeta meta = this.commandManager.metaBuilder(alias).plugin((Object)this).build();
            this.commandManager.register(meta, (Command)command);
        }
        this.registeredAliases.put(primary, aliases);
        this.logger.info("Registered macro '{}' with aliases {} and perm '{}'", new Object[]{primary, aliases, spec.getPermission()});
    }
}

