/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro.runtime;

import java.time.Duration;
import java.util.List;
import top.ourisland.litemacro.actions.Action;
import top.ourisland.litemacro.runtime.InvocationContext;

public class MacroRunner {
    private final InvocationContext ctx;
    private final List<Action> actions;

    public MacroRunner(InvocationContext ctx, List<Action> actions) {
        this.ctx = ctx;
        this.actions = actions;
    }

    public void start() {
        this.runStep(0);
    }

    private void runStep(int idx) {
        if (idx >= this.actions.size()) {
            return;
        }
        Action a = this.actions.get(idx);
        long delay = a.delayMillis();
        Runnable step = () -> {
            try {
                a.execute(this.ctx);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.runStep(idx + 1);
        };
        if (delay > 0L) {
            this.ctx.server().getScheduler().buildTask(this.ctx.plugin(), scheduled -> step.run()).delay(Duration.ofMillis(delay)).schedule();
        } else {
            step.run();
        }
    }
}

