/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro.runtime;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import top.ourisland.litemacro.config.ConfigManager;

public class I18n {
    private static ResourceBundle resourceBundle;
    private static Logger logger;
    private static ConfigManager configManager;

    public static void init(ConfigManager configManager, Logger logger) {
        I18n.configManager = configManager;
        I18n.logger = logger;
        I18n.loadResourceBundle(configManager.getLang());
    }

    public static void loadResourceBundle(String lang) {
        try {
            resourceBundle = ResourceBundle.getBundle("lang/" + lang);
        }
        catch (Exception e) {
            resourceBundle = ResourceBundle.getBundle("lang/en_US");
            logger.warn("Failed to load language '{}'. Falling back to default language 'en_US'.", (Object)lang);
        }
    }

    public static Component lang(String key, Object ... args) {
        String formattedMessage = I18n.getString("litemacro.prefix") + MessageFormat.format(I18n.getString(key), args);
        return Component.text((String)formattedMessage);
    }

    public static String getString(String key) {
        return resourceBundle.getString(key);
    }

    public static Component langPlain(String key, Object ... args) {
        String formattedMessage = MessageFormat.format(I18n.getString(key), args);
        return Component.text((String)formattedMessage);
    }

    public static Component langPlain(String key) {
        return Component.text((String)I18n.getString(key));
    }

    public static Component prefix(String text) {
        return Component.text((String)(I18n.getString("litemacro.prefix") + text));
    }
}

