/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro.config;

import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import top.ourisland.litemacro.config.model.MacroSpec;
import top.ourisland.litemacro.config.model.RootConfig;

public class ConfigManager {
    private final Logger logger;
    private final ProxyServer server;
    private final Path dataDir;
    private RootConfig root;

    public ConfigManager(Logger logger, ProxyServer server, Path dataDir) {
        this.logger = logger;
        this.server = server;
        this.dataDir = dataDir;
    }

    public void loadOrCreate() throws IOException {
        Path file = this.dataDir.resolve("command.yml");
        if (!Files.exists(file, new LinkOption[0])) {
            this.writeDefault(file);
        }
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(RootConfig.class));
            RootConfig loaded = (RootConfig)yaml.load(in);
            if (loaded == null || loaded.getMacros() == null) {
                this.root = new RootConfig();
                this.root.setMacros(Collections.emptyMap());
            } else {
                this.root = loaded;
            }
            for (Map.Entry<String, MacroSpec> e : this.root.getMacros().entrySet()) {
                if (e.getValue().getActions() != null && !e.getValue().getActions().isEmpty()) continue;
                this.logger.warn("Macro '{}' has no actions.", (Object)e.getKey());
            }
        }
    }

    private void writeDefault(Path file) throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("command.yml");){
            if (inputStream == null) {
                throw new IOException("Default resource file 'command.yml' not found in resources.");
            }
            Files.copy(inputStream, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public String getLang() {
        if (this.root == null || this.root.getLang() == null || this.root.getLang().isBlank()) {
            return "en_US";
        }
        return this.root.getLang();
    }

    public Map<String, MacroSpec> getMacros() {
        return this.root == null || this.root.getMacros() == null ? Collections.emptyMap() : this.root.getMacros();
    }
}

