/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.litemacro.actions;

import java.util.Locale;
import java.util.Map;
import top.ourisland.litemacro.actions.Action;
import top.ourisland.litemacro.actions.CommandAction;
import top.ourisland.litemacro.actions.DelayAction;
import top.ourisland.litemacro.actions.MessageAction;
import top.ourisland.litemacro.actions.TransferAction;
import top.ourisland.litemacro.config.model.ActionSpec;

public class ActionFactory {
    public static Action fromSpec(ActionSpec spec) throws IllegalArgumentException {
        String t = spec.getType();
        if (t == null) {
            throw new IllegalArgumentException("Action type is null");
        }
        String type = t.toLowerCase(Locale.ROOT);
        Map<String, Object> opt = spec.getOptions();
        switch (type) {
            case "command": {
                String cmd = ActionFactory.str(opt, "cmd", "");
                String runAs = ActionFactory.str(opt, "run_as", "console");
                return new CommandAction(cmd, runAs);
            }
            case "message": {
                String text = ActionFactory.str(opt, "text", "");
                return new MessageAction(text);
            }
            case "delay": {
                long ms = ActionFactory.num(opt, "millis", 0L);
                return new DelayAction(ms);
            }
            case "transfer": {
                String target = ActionFactory.str(opt, "target", "");
                String msg = ActionFactory.str(opt, "message", "");
                return new TransferAction(target, msg);
            }
        }
        throw new IllegalArgumentException("Unknown action type: " + type);
    }

    private static String str(Map<String, Object> m, String k, String def) {
        Object v = m == null ? null : m.get(k);
        return v == null ? def : String.valueOf(v);
    }

    private static long num(Map<String, Object> m, String k, long def) {
        Object v;
        Object object = v = m == null ? null : m.get(k);
        if (v == null) {
            return def;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        try {
            return Long.parseLong(String.valueOf(v));
        }
        catch (Exception e) {
            return def;
        }
    }
}

