/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.util;

import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class YamlUtil {
    private static final Yaml YAML;

    private YamlUtil() {
    }

    public static Object parse(String yamlText) {
        if (yamlText == null || yamlText.isBlank()) {
            return Map.of();
        }
        Object o = YAML.load(yamlText);
        return o == null ? Map.of() : o;
    }

    public static String getString(Map<?, ?> m, String key, String def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        return v == null ? def : String.valueOf(v);
    }

    public static boolean getBool(Map<?, ?> m, String key, boolean def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return b;
        }
        return Boolean.parseBoolean(String.valueOf(v));
    }

    public static long getLong(Map<?, ?> m, String key, long def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return n.longValue();
        }
        try {
            return Long.parseLong(String.valueOf(v));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static double getDouble(Map<?, ?> m, String key, double def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return n.doubleValue();
        }
        try {
            return Double.parseDouble(String.valueOf(v));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Map<?, ?> getMap(Map<?, ?> m, String key) {
        if (m == null) {
            return Map.of();
        }
        Object v = m.get(key);
        Map<?, ?> mm = YamlUtil.asMap(v);
        return mm == null ? Map.of() : mm;
    }

    public static Map<?, ?> asMap(Object o) {
        Map m;
        return o instanceof Map ? (m = (Map)o) : null;
    }

    public static List<?> getList(Map<?, ?> m, String key) {
        if (m == null) {
            return List.of();
        }
        Object v = m.get(key);
        List<?> l = YamlUtil.asList(v);
        return l == null ? List.of() : l;
    }

    public static List<?> asList(Object o) {
        List l;
        return o instanceof List ? (l = (List)o) : null;
    }

    static {
        LoaderOptions opt = new LoaderOptions();
        YAML = new Yaml((BaseConstructor)new SafeConstructor(opt));
    }
}

