/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.util;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Cron5 {
    private final Field minute;
    private final Field hour;
    private final Field dayOfMonth;
    private final Field month;
    private final Field dayOfWeek;

    private Cron5(Field minute, Field hour, Field dayOfMonth, Field month, Field dayOfWeek) {
        this.minute = minute;
        this.hour = hour;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.dayOfWeek = dayOfWeek;
    }

    public static Cron5 parse(String expr) {
        String[] parts;
        if (expr == null) {
            return null;
        }
        String e = expr.trim();
        if (e.isEmpty()) {
            throw new IllegalArgumentException("Cron expression is empty.");
        }
        if (e.startsWith("@")) {
            e = switch (e.toLowerCase(Locale.ROOT)) {
                case "@yearly", "@annually" -> "0 0 1 1 *";
                case "@monthly" -> "0 0 1 * *";
                case "@weekly" -> "0 0 * * 0";
                case "@daily", "@midnight" -> "0 0 * * *";
                case "@hourly" -> "0 * * * *";
                default -> throw new IllegalArgumentException("Unknown cron macro: " + e);
            };
        }
        if ((parts = e.split("\\s+")).length != 5) {
            throw new IllegalArgumentException("Cron must have 5 fields.");
        }
        return new Cron5(Field.parse(parts[0], Spec.MINUTE), Field.parse(parts[1], Spec.HOUR), Field.parse(parts[2], Spec.DOM), Field.parse(parts[3], Spec.MONTH), Field.parse(parts[4], Spec.DOW));
    }

    public ZonedDateTime nextAfter(ZonedDateTime after) {
        ZonedDateTime t = after.plusMinutes(1L).withSecond(0).withNano(0);
        ZonedDateTime end = t.plusYears(10L);
        while (!t.isAfter(end)) {
            int mon = t.getMonthValue();
            int nextMon = this.month.nextOrSame(mon);
            if (nextMon == -1) {
                int firstMon = this.month.first();
                if (firstMon == -1) {
                    return null;
                }
                t = Cron5.at(t, t.getYear() + 1, firstMon, 1, 0, 0);
                continue;
            }
            if (nextMon != mon) {
                t = Cron5.at(t, t.getYear(), nextMon, 1, 0, 0);
                continue;
            }
            ZonedDateTime dayAligned = this.findNextValidDayInMonth(t);
            if (dayAligned == null) {
                if ((t = this.advanceToNextAllowedMonth(t)) != null) continue;
                return null;
            }
            if (!Cron5.sameDate(dayAligned, t)) {
                int h0 = this.hour.firstOrMin();
                int m0 = this.minute.firstOrMin();
                t = Cron5.at(dayAligned, dayAligned.getYear(), dayAligned.getMonthValue(), dayAligned.getDayOfMonth(), h0, m0);
                continue;
            }
            int hr = t.getHour();
            int nextHr = this.hour.nextOrSame(hr);
            if (nextHr == -1) {
                ZonedDateTime nd = t.plusDays(1L);
                int h0 = this.hour.firstOrMin();
                int m0 = this.minute.firstOrMin();
                t = Cron5.at(nd, nd.getYear(), nd.getMonthValue(), nd.getDayOfMonth(), h0, m0);
                continue;
            }
            if (nextHr != hr) {
                int m0 = this.minute.firstOrMin();
                t = Cron5.at(t, t.getYear(), t.getMonthValue(), t.getDayOfMonth(), nextHr, m0);
                continue;
            }
            int min = t.getMinute();
            int nextMin = this.minute.nextOrSame(min);
            if (nextMin == -1) {
                ZonedDateTime nh = t.plusHours(1L);
                int m0 = this.minute.firstOrMin();
                t = Cron5.at(nh, nh.getYear(), nh.getMonthValue(), nh.getDayOfMonth(), nh.getHour(), m0);
                continue;
            }
            if (nextMin != min) {
                t = Cron5.at(t, t.getYear(), t.getMonthValue(), t.getDayOfMonth(), t.getHour(), nextMin);
            }
            if (this.matches(t)) {
                return t;
            }
            t = t.plusMinutes(1L).withSecond(0).withNano(0);
        }
        return null;
    }

    private static ZonedDateTime at(ZonedDateTime base, int year, int month, int day, int hour, int minute) {
        return ZonedDateTime.ofLocal(LocalDateTime.of(year, month, day, hour, minute), base.getZone(), null).withSecond(0).withNano(0);
    }

    private ZonedDateTime findNextValidDayInMonth(ZonedDateTime t) {
        int year = t.getYear();
        int mon = t.getMonthValue();
        int startDom = t.getDayOfMonth();
        int maxDom = t.toLocalDate().lengthOfMonth();
        for (int dom = startDom; dom <= maxDom; ++dom) {
            ZonedDateTime cand = Cron5.at(t, year, mon, dom, t.getHour(), t.getMinute());
            if (!this.dayMatches(cand)) continue;
            return cand;
        }
        return null;
    }

    private ZonedDateTime advanceToNextAllowedMonth(ZonedDateTime t) {
        int year = t.getYear();
        int mon = t.getMonthValue();
        int next = this.month.nextAfter(mon);
        if (next != -1) {
            return Cron5.at(t, year, next, 1, 0, 0);
        }
        int first = this.month.first();
        if (first == -1) {
            return null;
        }
        return Cron5.at(t, year + 1, first, 1, 0, 0);
    }

    private static boolean sameDate(ZonedDateTime a, ZonedDateTime b) {
        return a.getYear() == b.getYear() && a.getMonthValue() == b.getMonthValue() && a.getDayOfMonth() == b.getDayOfMonth();
    }

    private boolean matches(ZonedDateTime zdt) {
        int min = zdt.getMinute();
        int hr = zdt.getHour();
        int mon = zdt.getMonthValue();
        if (!this.minute.matches(min)) {
            return false;
        }
        if (!this.hour.matches(hr)) {
            return false;
        }
        if (!this.month.matches(mon)) {
            return false;
        }
        return this.dayMatches(zdt);
    }

    private boolean dayMatches(ZonedDateTime zdt) {
        int dom = zdt.getDayOfMonth();
        int dow = zdt.getDayOfWeek().getValue() % 7;
        boolean domUnspec = this.dayOfMonth.unspecified;
        boolean dowUnspec = this.dayOfWeek.unspecified;
        boolean domAny = this.dayOfMonth.any;
        boolean dowAny = this.dayOfWeek.any;
        boolean domMatch = this.dayOfMonth.matches(dom);
        boolean dowMatch = this.dayOfWeek.matches(dow);
        if (domUnspec && dowUnspec) {
            return true;
        }
        if (domUnspec) {
            return dowMatch;
        }
        if (dowUnspec) {
            return domMatch;
        }
        if (domAny && dowAny) {
            return true;
        }
        if (domAny) {
            return dowMatch;
        }
        if (dowAny) {
            return domMatch;
        }
        return domMatch || dowMatch;
    }

    private record Field(boolean any, boolean unspecified, BitSet allowed, int min, int max, Map<String, Integer> names) {
        static Field parse(String s, Spec spec) {
            String raw;
            if (s == null) {
                throw new IllegalArgumentException("Cron field is null.");
            }
            switch (raw = s.trim().toLowerCase(Locale.ROOT)) {
                case "": {
                    throw new IllegalArgumentException("Cron field is empty.");
                }
                case "*": {
                    return new Field(true, false, null, spec.min, spec.max, spec.names);
                }
                case "?": {
                    if (!spec.allowQuestion) {
                        throw new IllegalArgumentException("'?' is only allowed for day-of-month/day-of-week.");
                    }
                    return new Field(true, true, null, spec.min, spec.max, spec.names);
                }
            }
            BitSet bs = new BitSet(spec.max + 1);
            String[] items = raw.split(",");
            Arrays.stream(items).map(String::trim).filter(part -> !part.isEmpty()).forEach(part -> Field.addPart(bs, part, spec));
            if (bs.isEmpty()) {
                throw new IllegalArgumentException("Cron field has no valid values: " + s);
            }
            return new Field(false, false, bs, spec.min, spec.max, spec.names);
        }

        private static void addPart(BitSet bs, String part, Spec spec) {
            int end;
            int start;
            String base = part;
            int step = 1;
            int slash = part.indexOf(47);
            if (slash >= 0) {
                base = part.substring(0, slash).trim();
                String stepStr = part.substring(slash + 1).trim();
                if (stepStr.isEmpty()) {
                    throw new IllegalArgumentException("Missing step in: " + part);
                }
                step = Integer.parseInt(stepStr);
                if (step <= 0) {
                    throw new IllegalArgumentException("Step must be > 0 in: " + part);
                }
            }
            if (base.isEmpty() || "*".equals(base)) {
                start = spec.min;
                end = spec.max;
            } else {
                int dash = base.indexOf(45);
                if (dash >= 0) {
                    String a = base.substring(0, dash).trim();
                    String b = base.substring(dash + 1).trim();
                    if (a.isEmpty() || b.isEmpty()) {
                        throw new IllegalArgumentException("Bad range: " + part);
                    }
                    start = Field.parseValue(a, spec);
                    end = Field.parseValue(b, spec);
                } else {
                    start = Field.parseValue(base, spec);
                    int n = end = slash >= 0 ? spec.max : start;
                }
            }
            if (spec == Spec.DOW) {
                if (start == 7) {
                    start = 0;
                }
                if (end == 7) {
                    end = 0;
                }
            }
            if (start <= end) {
                Field.fill(bs, start, end, step, spec);
            } else {
                Field.fill(bs, start, spec.max, step, spec);
                Field.fill(bs, spec.min, end, step, spec);
            }
        }

        private static int parseValue(String token, Spec spec) {
            Integer v;
            String t = token.trim().toLowerCase(Locale.ROOT);
            if (t.isEmpty()) {
                throw new IllegalArgumentException("Empty value token.");
            }
            if (spec.names != null && (v = spec.names.get(t)) != null) {
                return v;
            }
            int v2 = Integer.parseInt(t);
            if (spec == Spec.DOW && v2 == 7) {
                return 0;
            }
            return v2;
        }

        private static void fill(BitSet bs, int start, int end, int step, Spec spec) {
            if (start < spec.min || start > spec.max) {
                throw new IllegalArgumentException("Value out of range: " + start);
            }
            if (end < spec.min || end > spec.max) {
                throw new IllegalArgumentException("Value out of range: " + end);
            }
            for (int v = start; v <= end; v += step) {
                bs.set(v);
            }
        }

        boolean matches(int v) {
            if (this.any) {
                return true;
            }
            return this.allowed != null && v >= this.min && v <= this.max && this.allowed.get(v);
        }

        int nextOrSame(int v) {
            if (this.any) {
                return v;
            }
            if (this.allowed == null) {
                return -1;
            }
            int n = this.allowed.nextSetBit(v);
            return n == -1 || n > this.max ? -1 : n;
        }

        int nextAfter(int v) {
            if (this.any) {
                return v < this.max ? v + 1 : -1;
            }
            if (this.allowed == null) {
                return -1;
            }
            int n = this.allowed.nextSetBit(v + 1);
            return n == -1 || n > this.max ? -1 : n;
        }

        int firstOrMin() {
            int f = this.first();
            return f == -1 ? this.min : f;
        }

        int first() {
            if (this.any) {
                return this.min;
            }
            if (this.allowed == null) {
                return -1;
            }
            int n = this.allowed.nextSetBit(this.min);
            return n == -1 || n > this.max ? -1 : n;
        }
    }

    private static enum Spec {
        MINUTE(0, 59, false, null),
        HOUR(0, 23, false, null),
        DOM(1, 31, true, null),
        MONTH(1, 12, false, Spec.monthNames()),
        DOW(0, 6, true, Spec.dowNames());

        final int min;
        final int max;
        final boolean allowQuestion;
        final Map<String, Integer> names;

        private Spec(int min, int max, boolean allowQuestion, Map<String, Integer> names) {
            this.min = min;
            this.max = max;
            this.allowQuestion = allowQuestion;
            this.names = names;
        }

        private static Map<String, Integer> monthNames() {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            m.put("jan", 1);
            m.put("feb", 2);
            m.put("mar", 3);
            m.put("apr", 4);
            m.put("may", 5);
            m.put("jun", 6);
            m.put("jul", 7);
            m.put("aug", 8);
            m.put("sep", 9);
            m.put("oct", 10);
            m.put("nov", 11);
            m.put("dec", 12);
            return m;
        }

        private static Map<String, Integer> dowNames() {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            m.put("sun", 0);
            m.put("mon", 1);
            m.put("tue", 2);
            m.put("wed", 3);
            m.put("thu", 4);
            m.put("fri", 5);
            m.put("sat", 6);
            return m;
        }
    }
}

