/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.showcase;

import com.velocitypowered.api.proxy.Player;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import top.ourisland.invertotimer.runtime.RuntimeContext;
import top.ourisland.invertotimer.showcase.Showcase;

public class TitleShowcase
implements Showcase {
    private final RuntimeContext ctx;
    private final Supplier<Object> textSupplier;

    public TitleShowcase(@NonNull RuntimeContext ctx, @NonNull Supplier<Object> textSupplier) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (textSupplier == null) {
            throw new NullPointerException("textSupplier is marked non-null but is null");
        }
        this.ctx = ctx;
        this.textSupplier = textSupplier;
    }

    @Override
    public String name() {
        return "title";
    }

    @Override
    public String description() {
        return "Show title";
    }

    @Override
    public void show() {
        Parsed p0 = TitleShowcase.parse(this.textSupplier.get());
        Title.Times times = Title.Times.times((Duration)Duration.ofSeconds(p0.fadeIn()), (Duration)Duration.ofSeconds(p0.stay()), (Duration)Duration.ofSeconds(p0.fadeOut()));
        for (Player p : this.ctx.players()) {
            if (!this.ctx.allowed(p)) continue;
            Component t = this.ctx.render(p, p0.title());
            Component s = this.ctx.render(p, p0.subtitle());
            p.showTitle(Title.title((Component)t, (Component)s, (Title.Times)times));
        }
    }

    private static Parsed parse(Object raw) {
        String title = "";
        String subtitle = "";
        long fadeIn = 0L;
        long stay = 2L;
        long fadeOut = 0L;
        if (raw instanceof List) {
            List list = (List)raw;
            if (!list.isEmpty()) {
                title = String.valueOf(list.get(0));
            }
            if (list.size() > 1) {
                subtitle = String.valueOf(list.get(1));
            }
            if (list.size() > 2) {
                fadeIn = TitleShowcase.parseSeconds(list.get(2), 0L);
            }
            if (list.size() > 3) {
                stay = TitleShowcase.parseSeconds(list.get(3), 2L);
            }
            if (list.size() > 4) {
                fadeOut = TitleShowcase.parseSeconds(list.get(4), 0L);
            }
        } else if (raw instanceof Object[]) {
            Object[] arr = (Object[])raw;
            if (arr.length > 0) {
                title = String.valueOf(arr[0]);
            }
            if (arr.length > 1) {
                subtitle = String.valueOf(arr[1]);
            }
            if (arr.length > 2) {
                fadeIn = TitleShowcase.parseSeconds(arr[2], 0L);
            }
            if (arr.length > 3) {
                stay = TitleShowcase.parseSeconds(arr[3], 2L);
            }
            if (arr.length > 4) {
                fadeOut = TitleShowcase.parseSeconds(arr[4], 0L);
            }
        } else if (raw != null) {
            title = String.valueOf(raw);
            subtitle = "";
        }
        if (title == null) {
            title = "";
        }
        if (subtitle == null) {
            subtitle = "";
        }
        if (fadeIn < 0L) {
            fadeIn = 0L;
        }
        if (stay < 0L) {
            stay = 0L;
        }
        if (fadeOut < 0L) {
            fadeOut = 0L;
        }
        return new Parsed(title, subtitle, fadeIn, stay, fadeOut);
    }

    private static long parseSeconds(Object o, long def) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.longValue();
        }
        try {
            return Long.parseLong(String.valueOf(o));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private record Parsed(String title, String subtitle, long fadeIn, long stay, long fadeOut) {
    }
}

