/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.timer;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import top.ourisland.invertotimer.InvertoTimer;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.config.ConfigManager;
import top.ourisland.invertotimer.config.model.ActionConfig;
import top.ourisland.invertotimer.config.model.AnimationConfig;
import top.ourisland.invertotimer.config.model.GlobalConfig;
import top.ourisland.invertotimer.config.model.ShowcaseConfig;
import top.ourisland.invertotimer.config.model.TimerConfig;
import top.ourisland.invertotimer.runtime.PlaceholderEngine;
import top.ourisland.invertotimer.runtime.RuntimeContext;
import top.ourisland.invertotimer.runtime.action.ActionFactory;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseFactory;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseSlot;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseType;
import top.ourisland.invertotimer.showcase.BossbarShowcase;
import top.ourisland.invertotimer.showcase.Showcase;
import top.ourisland.invertotimer.util.Cron5;

final class TimerInstance {
    private static final DateTimeFormatter TIME_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final InvertoTimer plugin;
    private final ProxyServer proxy;
    private final Logger logger;
    private final ConfigManager configManager;
    private final TimerConfig cfg;
    private final ZoneId zoneId;
    private final List<ScheduledTask> actionTasks = new ArrayList<ScheduledTask>();
    private final Map<String, ShowcaseSlot> showcaseSlots = new HashMap<String, ShowcaseSlot>();
    private final PlaceholderEngine placeholders;
    private Instant expireAt = Instant.EPOCH;
    private Cron5 cron;
    private LocalDateTime oneTime;
    private ZonedDateTime nextTarget;
    private volatile GlobalConfig lastGlobal;
    private volatile Instant lastNow;
    private BossbarShowcase bossbarShowcase;
    private ShowcaseSlot bossbarSlot;
    private ShowcaseConfig bossBarConfig;
    private RuntimeContext ctx;

    TimerInstance(@NonNull InvertoTimer plugin, ProxyServer proxy, Logger logger, ConfigManager configManager, TimerConfig cfg, ZoneId zoneId) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
        this.proxy = proxy;
        this.logger = logger;
        this.configManager = configManager;
        this.placeholders = new PlaceholderEngine(configManager);
        this.cfg = cfg;
        this.zoneId = zoneId;
        this.parseTimeSpec();
        this.buildRuntimeContext();
        this.rebuildForNewTarget();
    }

    private void parseTimeSpec() {
        try {
            if (this.cfg.cron() != null && !this.cfg.cron().isBlank()) {
                this.cron = Cron5.parse(this.cfg.cron());
            }
        }
        catch (Exception ignored) {
            this.cron = null;
        }
        try {
            if (this.cfg.time() != null && !this.cfg.time().isBlank()) {
                this.oneTime = LocalDateTime.parse(this.cfg.time(), TIME_FMT);
            }
        }
        catch (Exception ignored) {
            this.oneTime = null;
        }
    }

    private void buildRuntimeContext() {
        this.ctx = new RuntimeContext(this.proxy, this::isPlayerAllowedUsingLastGlobal, this.placeholders, () -> this.buildPlaceholderContext(this.lastNow == null ? Instant.now() : this.lastNow), this.logger);
    }

    private void rebuildForNewTarget() {
        Instant targetInstant;
        this.cancelActionTasks();
        this.showcaseSlots.clear();
        this.bossbarShowcase = null;
        this.bossbarSlot = null;
        this.bossBarConfig = null;
        this.expireAt = Instant.EPOCH;
        if (this.nextTarget == null) {
            return;
        }
        this.expireAt = targetInstant = this.nextTarget.toInstant();
        for (ActionConfig actionConfig : this.cfg.actions()) {
            Instant at = targetInstant.plus(actionConfig.shift());
            Action action = ActionFactory.create(actionConfig, this.ctx);
            if (action == null) continue;
            this.scheduleAction(at, action);
            if (!at.isAfter(this.expireAt)) continue;
            this.expireAt = at;
        }
        for (Map.Entry entry : this.cfg.showcases().entrySet()) {
            BossbarShowcase bbs;
            Showcase showcase;
            ShowcaseType kind;
            String key = (String)entry.getKey();
            ShowcaseConfig sc = (ShowcaseConfig)entry.getValue();
            if (sc == null || !sc.enabled() || (kind = ShowcaseType.fromKey(key)) == null || (showcase = ShowcaseFactory.create(key, sc, this.ctx, () -> this.textFor(sc, this.lastNow == null ? Instant.now() : this.lastNow), () -> Float.valueOf(this.progressFor(sc, this.lastNow == null ? Instant.now() : this.lastNow)))) == null) continue;
            ShowcaseSlot slot = new ShowcaseSlot(kind, sc, showcase);
            this.showcaseSlots.put(key.toLowerCase(Locale.ROOT), slot);
            if (!(showcase instanceof BossbarShowcase)) continue;
            this.bossbarShowcase = bbs = (BossbarShowcase)showcase;
            this.bossbarSlot = slot;
            this.bossBarConfig = sc;
        }
    }

    private boolean isPlayerAllowedUsingLastGlobal(Player p) {
        GlobalConfig g = this.lastGlobal;
        if (g == null) {
            return true;
        }
        return this.isPlayerAllowed(p, g);
    }

    private PlaceholderEngine.Context buildPlaceholderContext(Instant now) {
        long remainingSec = this.nextTarget == null ? 0L : Math.max(0L, Duration.between(now, this.nextTarget.toInstant()).getSeconds());
        String targetText = this.nextTarget == null ? "" : TIME_FMT.format(this.nextTarget);
        return new PlaceholderEngine.Context(this.cfg.id(), this.cfg.description(), now, this.nextTarget, targetText, remainingSec);
    }

    private void cancelActionTasks() {
        for (ScheduledTask t : this.actionTasks) {
            try {
                t.cancel();
            }
            catch (Exception exception) {}
        }
        this.actionTasks.clear();
    }

    private void scheduleAction(Instant at, Action action) {
        long delayMs = at.toEpochMilli() - System.currentTimeMillis();
        if (delayMs < 0L) {
            delayMs = 0L;
        }
        ScheduledTask task = this.proxy.getScheduler().buildTask((Object)this.plugin, () -> {
            this.lastNow = Instant.now();
            try {
                action.execute();
            }
            catch (Exception e) {
                this.logger.error("Failed executing action {} for timer {}", new Object[]{action.name(), this.cfg.id(), e});
            }
        }).delay(delayMs, TimeUnit.MILLISECONDS).schedule();
        this.actionTasks.add(task);
    }

    private Object textFor(ShowcaseConfig sc, Instant now) {
        if (this.nextTarget == null) {
            return sc.text();
        }
        ShowcaseConfig.After af = sc.after();
        if (af == null || af.duration() == null || af.duration().isZero() || af.text() == null) {
            return sc.text();
        }
        Instant target = this.nextTarget.toInstant();
        Instant end = target.plus(af.duration());
        if (!now.isBefore(target) && !now.isAfter(end)) {
            return af.text();
        }
        return sc.text();
    }

    private float progressFor(ShowcaseConfig sc, Instant now) {
        if (this.nextTarget == null) {
            return 1.0f;
        }
        Instant target = this.nextTarget.toInstant();
        Duration startAt = sc.startAt();
        if (startAt != null && !startAt.isZero()) {
            float p;
            long total = startAt.abs().getSeconds();
            long rem = Math.max(0L, Duration.between(now, target).getSeconds());
            float f = p = total == 0L ? 0.0f : (float)rem / (float)total;
            if (p < 0.0f) {
                p = 0.0f;
            }
            if (p > 1.0f) {
                p = 1.0f;
            }
            return p;
        }
        long rem = Math.max(0L, Duration.between(now, target).getSeconds());
        return rem > 0L ? 1.0f : 0.0f;
    }

    private boolean isPlayerAllowed(Player p, GlobalConfig global) {
        String serverName = p.getCurrentServer().map(c -> c.getServerInfo().getName()).orElse(null);
        if (!global.limitation().isAllowed(serverName)) {
            return false;
        }
        return this.cfg.limitation().isAllowed(serverName);
    }

    private String animationFrameText(String id, Instant now) {
        if (id == null || id.isBlank()) {
            return "";
        }
        AnimationConfig anim = this.configManager.animations().get(id);
        if (anim == null) {
            return "";
        }
        List<AnimationConfig.Frame> frames = anim.frames();
        if (frames == null || frames.isEmpty()) {
            return "";
        }
        long total = Math.max(1L, anim.totalDurationMs());
        long pos = Math.floorMod(now.toEpochMilli(), total);
        long acc = 0L;
        for (AnimationConfig.Frame f : frames) {
            if (pos >= (acc += Math.max(1L, f.durationMs()))) continue;
            return f.text() == null ? "" : f.text();
        }
        AnimationConfig.Frame last = frames.getLast();
        return last.text() == null ? "" : last.text();
    }

    void tick(Instant now, GlobalConfig global) {
        this.lastNow = now;
        this.lastGlobal = global;
        this.ensureNextTarget(now);
        this.updateShowcases(now);
    }

    void ensureNextTarget(Instant now) {
        if (this.nextTarget == null) {
            this.nextTarget = this.computeNextTarget(now);
            this.rebuildForNewTarget();
            return;
        }
        if (now.isAfter(this.getExpireTime())) {
            this.nextTarget = this.computeNextTarget(now);
            this.rebuildForNewTarget();
        }
    }

    private void updateShowcases(Instant now) {
        if (this.nextTarget == null) {
            return;
        }
        long nowMs = now.toEpochMilli();
        for (ShowcaseSlot slot : this.showcaseSlots.values()) {
            if (!this.shouldShow(slot, now)) continue;
            Duration interval = slot.config().interval();
            if (interval == null) {
                interval = slot.kind().defaultInterval();
            }
            if (!slot.tryAcquire(nowMs, interval.toMillis())) continue;
            try {
                slot.showcase().show();
            }
            catch (Exception e) {
                this.logger.error("Failed showing {} for timer {}", new Object[]{slot.showcase().name(), this.cfg.id(), e});
            }
        }
    }

    private ZonedDateTime computeNextTarget(Instant now) {
        ZonedDateTime zNow = ZonedDateTime.ofInstant(now, this.zoneId).withSecond(0).withNano(0);
        if (this.oneTime != null) {
            ZonedDateTime target = this.oneTime.atZone(this.zoneId);
            return target.isAfter(zNow) ? target : null;
        }
        if (this.cron != null) {
            return this.cron.nextAfter(zNow);
        }
        return null;
    }

    private Instant getExpireTime() {
        Instant last = this.expireAt;
        if (this.nextTarget != null) {
            Instant target = this.nextTarget.toInstant();
            for (ShowcaseSlot slot : this.showcaseSlots.values()) {
                Instant end;
                ShowcaseConfig.After af;
                boolean allowAfter;
                if (!(allowAfter = (switch (slot.kind()) {
                    case ShowcaseType.ACTIONBAR, ShowcaseType.BOSSBAR, ShowcaseType.TITLE -> true;
                    default -> false;
                })) || (af = slot.config().after()) == null || af.duration() == null || af.duration().isZero() || !(end = target.plus(af.duration())).isAfter(last)) continue;
                last = end;
            }
        }
        return last.plusSeconds(2L);
    }

    private boolean shouldShow(ShowcaseSlot slot, Instant now) {
        if (this.nextTarget == null) {
            return false;
        }
        ShowcaseConfig sc = slot.config();
        Instant target = this.nextTarget.toInstant();
        Instant begin = sc.startAt() == null ? Instant.EPOCH : target.minus(sc.startAt().abs());
        Instant end = target;
        boolean allowAfter = switch (slot.kind()) {
            case ShowcaseType.ACTIONBAR, ShowcaseType.BOSSBAR, ShowcaseType.TITLE -> true;
            default -> false;
        };
        ShowcaseConfig.After af = sc.after();
        if (allowAfter && af != null && af.duration() != null && !af.duration().isZero()) {
            end = target.plus(af.duration());
        }
        if (now.isBefore(begin)) {
            return false;
        }
        return !now.isAfter(end);
    }

    String peekNext() {
        return this.nextTarget == null ? null : this.nextTarget.toString();
    }

    void refreshFor(Player p) {
        Instant now;
        if (this.bossbarShowcase == null || this.bossbarSlot == null) {
            return;
        }
        Instant instant = now = this.lastNow == null ? Instant.now() : this.lastNow;
        if (this.nextTarget == null) {
            return;
        }
        if (!this.shouldShow(this.bossbarSlot, now)) {
            this.bossbarShowcase.hideFrom(p);
            return;
        }
        if (!this.isPlayerAllowedUsingLastGlobal(p)) {
            this.bossbarShowcase.hideFrom(p);
            return;
        }
        this.bossbarShowcase.showTo(p);
    }

    void hideFor(Player p) {
        if (this.bossbarShowcase != null) {
            this.bossbarShowcase.hideFrom(p);
        }
    }

    void dispose() {
        this.cancelActionTasks();
        if (this.bossbarShowcase != null) {
            for (Player p : this.proxy.getAllPlayers()) {
                try {
                    this.bossbarShowcase.hideFrom(p);
                }
                catch (Exception exception) {}
            }
        }
    }
}

