/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.showcase;

import lombok.Generated;
import top.ourisland.invertotimer.config.model.ShowcaseConfig;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseType;
import top.ourisland.invertotimer.showcase.Showcase;

public final class ShowcaseSlot {
    private final ShowcaseType kind;
    private final ShowcaseConfig config;
    private final Showcase showcase;
    private long lastSentMs = 0L;

    public ShowcaseSlot(ShowcaseType kind, ShowcaseConfig config, Showcase showcase) {
        this.kind = kind;
        this.config = config;
        this.showcase = showcase;
    }

    public boolean tryAcquire(long nowMs, long intervalMs) {
        if (intervalMs <= 0L) {
            return true;
        }
        if (nowMs - this.lastSentMs < intervalMs) {
            return false;
        }
        this.lastSentMs = nowMs;
        return true;
    }

    @Generated
    public ShowcaseType kind() {
        return this.kind;
    }

    @Generated
    public ShowcaseConfig config() {
        return this.config;
    }

    @Generated
    public Showcase showcase() {
        return this.showcase;
    }

    @Generated
    public long lastSentMs() {
        return this.lastSentMs;
    }
}

