/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.slf4j.Logger;
import top.ourisland.invertotimer.runtime.MiniPlaceholdersHook;
import top.ourisland.invertotimer.runtime.PlaceholderEngine;

public final class RuntimeContext {
    private final ProxyServer proxy;
    private final Predicate<Player> allowed;
    private final PlaceholderEngine engine;
    private final Supplier<PlaceholderEngine.Context> ctxSupplier;
    private final TagResolver mpGlobal;
    private final TagResolver mpAudience;
    private final Logger logger;

    public RuntimeContext(@NonNull ProxyServer proxy, @NonNull Predicate<Player> allowed, @NonNull PlaceholderEngine engine, @NonNull Supplier<PlaceholderEngine.Context> ctxSupplier, @NonNull Logger logger) {
        if (proxy == null) {
            throw new NullPointerException("proxy is marked non-null but is null");
        }
        if (allowed == null) {
            throw new NullPointerException("allowed is marked non-null but is null");
        }
        if (engine == null) {
            throw new NullPointerException("engine is marked non-null but is null");
        }
        if (ctxSupplier == null) {
            throw new NullPointerException("ctxSupplier is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.proxy = proxy;
        this.allowed = allowed;
        this.engine = engine;
        this.ctxSupplier = ctxSupplier;
        TagResolver g = TagResolver.empty();
        TagResolver a = TagResolver.empty();
        if (proxy.getPluginManager().getPlugin("miniplaceholders").isPresent()) {
            try {
                MiniPlaceholdersHook hook = new MiniPlaceholdersHook();
                g = hook.global();
                a = hook.audience();
                logger.info("MiniPlaceholders detected: placeholder tags are enabled.");
            }
            catch (Throwable t) {
                logger.warn("MiniPlaceholders detected but failed to initialize integration. Continuing without it.", t);
            }
        }
        this.mpGlobal = g;
        this.mpAudience = a;
        this.logger = logger;
    }

    public Collection<Player> players() {
        return this.proxy.getAllPlayers();
    }

    public boolean allowed(Player p) {
        return this.allowed.test(p);
    }

    public Component render(String text) {
        return this.render(null, text);
    }

    public Component render(Player player, String text) {
        PlaceholderEngine.Context ctx = this.ctxSupplier.get();
        TagResolver resolver = player == null ? TagResolver.resolver((TagResolver[])new TagResolver[]{this.mpGlobal}) : TagResolver.resolver((TagResolver[])new TagResolver[]{this.mpGlobal, this.mpAudience});
        return this.engine.renderToComponent(text, (Audience)player, resolver, ctx);
    }

    public String renderString(String text) {
        return this.renderString(null, text);
    }

    public String renderString(Player player, String text) {
        PlaceholderEngine.Context ctx = this.ctxSupplier.get();
        return this.engine.apply(text, ctx);
    }

    @Generated
    public ProxyServer proxy() {
        return this.proxy;
    }

    @Generated
    public Logger logger() {
        return this.logger;
    }
}

