/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import top.ourisland.invertotimer.config.ConfigManager;
import top.ourisland.invertotimer.config.model.AnimationConfig;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.util.TimeUtil;

public final class PlaceholderEngine {
    private static final Pattern I18N_TOKEN = Pattern.compile("\\{i18n:([a-zA-Z0-9_.-]+)}");
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{([a-zA-Z0-9_.-]+)(?::([^}]*))?}");
    private static final Pattern ANIMATION = Pattern.compile("\\{animation:([a-zA-Z0-9_.-]+)}");
    private final ConfigManager configManager;

    public PlaceholderEngine(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public Component renderToComponent(String input, Audience audience, TagResolver resolver, Context ctx) {
        TagResolver r;
        String s = this.apply(input, ctx);
        TagResolver tagResolver = r = resolver == null ? TagResolver.empty() : resolver;
        if (audience != null) {
            return MiniMessage.miniMessage().deserialize(s, (Pointered)audience, r);
        }
        return MiniMessage.miniMessage().deserialize(s, r);
    }

    public String apply(String input, Context ctx) {
        if (input == null) {
            return "";
        }
        String s = this.expandAnimations(input, ctx);
        s = PlaceholderEngine.replaceI18n(s);
        return PlaceholderEngine.replaceCore(s, ctx);
    }

    private String expandAnimations(String input, Context ctx) {
        Matcher m = ANIMATION.matcher(input);
        if (!m.find()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        int last = 0;
        do {
            sb.append(input, last, m.start());
            String id = m.group(1);
            sb.append(this.animationFrameText(id, ctx));
            last = m.end();
        } while (m.find());
        sb.append(input, last, input.length());
        return sb.toString();
    }

    public static String replaceI18n(String input) {
        if (input == null) {
            return "";
        }
        Matcher m = I18N_TOKEN.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            Object rep;
            String key = m.group(1);
            try {
                rep = I18n.langStrNP(key);
            }
            catch (Exception e) {
                rep = "{missing:" + key + "}";
            }
            m.appendReplacement(sb, Matcher.quoteReplacement((String)rep));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String replaceCore(String input, Context ctx) {
        Matcher m = PLACEHOLDER.matcher(input);
        if (!m.find()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        int last = 0;
        do {
            sb.append(input, last, m.start());
            String key = m.group(1);
            String arg = m.group(2);
            String rep = PlaceholderEngine.resolve(key, arg, ctx);
            if (rep == null) {
                sb.append(m.group(0));
            } else {
                sb.append(rep);
            }
            last = m.end();
        } while (m.find());
        sb.append(input, last, input.length());
        return sb.toString();
    }

    private String animationFrameText(String id, Context ctx) {
        if (id == null || id.isBlank()) {
            return "";
        }
        Map<String, AnimationConfig> animations = this.configManager.animations();
        if (animations == null) {
            return "";
        }
        AnimationConfig cfg = animations.get(id);
        if (cfg == null) {
            return "";
        }
        long total = Math.max(1L, cfg.totalDurationMs());
        long offset = Math.floorMod(ctx.now().toEpochMilli(), total);
        long acc = 0L;
        for (AnimationConfig.Frame f : cfg.frames()) {
            long dur = Math.max(1L, f.durationMs());
            if (offset >= (acc += dur)) continue;
            return PlaceholderEngine.safe(f.text());
        }
        return PlaceholderEngine.safe(cfg.frames().isEmpty() ? "" : cfg.frames().getFirst().text());
    }

    private static String resolve(String keyRaw, String arg, Context ctx) {
        String key;
        if (keyRaw == null) {
            return null;
        }
        return switch (key = keyRaw.toLowerCase(Locale.ROOT)) {
            case "id" -> PlaceholderEngine.safe(ctx.id());
            case "description" -> PlaceholderEngine.safe(ctx.description());
            case "target" -> PlaceholderEngine.safe(ctx.targetText());
            case "total_seconds" -> String.valueOf(ctx.remainingSeconds());
            case "days" -> PlaceholderEngine.formatUnit(ctx.days(), arg);
            case "hours" -> PlaceholderEngine.formatUnit(ctx.hoursPart(), arg);
            case "minutes" -> PlaceholderEngine.formatUnit(ctx.minutesPart(), arg);
            case "seconds" -> PlaceholderEngine.formatUnit(ctx.secondsPart(), arg);
            case "remaining" -> PlaceholderEngine.formatRemaining(ctx, arg);
            case "i18n" -> null;
            case "animation" -> null;
            default -> null;
        };
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String formatUnit(long value, String suffix) {
        if (suffix == null) {
            return String.valueOf(value);
        }
        if (value <= 0L) {
            return "";
        }
        return value + suffix;
    }

    private static String formatRemaining(Context ctx, String format) {
        long sec = ctx.remainingSeconds();
        if (format == null || format.isBlank()) {
            return TimeUtil.formatHMS(sec);
        }
        RemainingFormat rf = RemainingFormat.parse(format);
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < rf.pieces.size(); ++i) {
            Piece p = rf.pieces.get(i);
            if (p.kind == Kind.LITERAL) {
                if (!PlaceholderEngine.shouldAppendLiteral(out, rf, i)) continue;
                out.append(p.literal);
                continue;
            }
            String part = PlaceholderEngine.formatUnitPiece(ctx, rf, p);
            if (part.isEmpty()) continue;
            out.append(part);
        }
        return out.toString().trim();
    }

    private static boolean shouldAppendLiteral(StringBuilder out, RemainingFormat rf, int idx) {
        if (out.length() == 0) {
            return false;
        }
        for (int i = idx + 1; i < rf.pieces.size(); ++i) {
            Piece p = rf.pieces.get(i);
            if (p.kind == Kind.UNIT && PlaceholderEngine.willEmitUnit(rf, p)) {
                return true;
            }
            if (p.kind == Kind.LITERAL && !p.literal.trim().isEmpty()) continue;
        }
        return false;
    }

    private static String formatUnitPiece(Context ctx, RemainingFormat rf, Piece p) {
        long v;
        if (p.kind != Kind.UNIT) {
            return "";
        }
        switch (p.unit) {
            case 'd': {
                v = ctx.days();
                break;
            }
            case 'h': {
                v = rf.usesDays ? ctx.hoursPart() : ctx.totalHours();
                break;
            }
            case 'm': {
                if (rf.usesDays || rf.usesHours) {
                    v = ctx.minutesPart();
                    break;
                }
                v = ctx.totalMinutes();
                break;
            }
            case 's': {
                v = rf.usesDays || rf.usesHours || rf.usesMinutes ? ctx.secondsPart() : ctx.remainingSeconds();
                break;
            }
            default: {
                return "";
            }
        }
        if (p.hideWhenZero && v <= 0L) {
            return "";
        }
        String num = PlaceholderEngine.toPaddedNumber(v, p.width);
        return num + p.suffix;
    }

    private static boolean willEmitUnit(RemainingFormat rf, Piece p) {
        return true;
    }

    private static String toPaddedNumber(long v, int width) {
        String s = String.valueOf(v);
        if (width <= 1) {
            return s;
        }
        if (s.length() >= width) {
            return s;
        }
        return "0".repeat(width - s.length()) + s;
    }

    public record Context(String id, String description, Instant now, ZonedDateTime target, String targetText, long remainingSeconds) {
        public long days() {
            return this.remainingSeconds / 86400L;
        }

        public long hoursPart() {
            return this.remainingSeconds % 86400L / 3600L;
        }

        public long minutesPart() {
            return this.remainingSeconds % 3600L / 60L;
        }

        public long secondsPart() {
            return this.remainingSeconds % 60L;
        }

        public long totalHours() {
            return this.remainingSeconds / 3600L;
        }

        public long totalMinutes() {
            return this.remainingSeconds / 60L;
        }
    }

    private record RemainingFormat(List<Piece> pieces, boolean usesDays, boolean usesHours, boolean usesMinutes) {
        static RemainingFormat parse(String fmt) {
            Piece p;
            String f = PlaceholderEngine.safe(fmt);
            ArrayList<Piece> pieces = new ArrayList<Piece>();
            boolean usesD = false;
            boolean usesH = false;
            boolean usesM = false;
            Matcher m = Pattern.compile("(:|\\s+)").matcher(f);
            int last = 0;
            while (m.find()) {
                String chunk = f.substring(last, m.start());
                if (!chunk.isEmpty()) {
                    p = RemainingFormat.parseChunk(chunk);
                    pieces.add(p);
                    if (p.kind == Kind.UNIT) {
                        if (p.unit == 'd') {
                            usesD = true;
                        }
                        if (p.unit == 'h') {
                            usesH = true;
                        }
                        if (p.unit == 'm') {
                            usesM = true;
                        }
                    }
                }
                pieces.add(Piece.literal(m.group(1)));
                last = m.end();
            }
            String tail = f.substring(last);
            if (!tail.isEmpty()) {
                p = RemainingFormat.parseChunk(tail);
                pieces.add(p);
                if (p.kind == Kind.UNIT) {
                    if (p.unit == 'd') {
                        usesD = true;
                    }
                    if (p.unit == 'h') {
                        usesH = true;
                    }
                    if (p.unit == 'm') {
                        usesM = true;
                    }
                }
            }
            return new RemainingFormat(pieces, usesD, usesH, usesM);
        }

        private static Piece parseChunk(String chunk) {
            int width;
            String c = chunk.trim();
            if (c.isEmpty()) {
                return Piece.literal(chunk);
            }
            char u = Character.toLowerCase(c.charAt(0));
            if (u != 'd' && u != 'h' && u != 'm' && u != 's') {
                return Piece.literal(chunk);
            }
            for (width = 0; width < c.length() && Character.toLowerCase(c.charAt(width)) == u; ++width) {
            }
            String suffix = c.substring(width);
            boolean hideWhenZero = !suffix.isEmpty();
            return Piece.unit(u, width, suffix, hideWhenZero);
        }
    }

    private record Piece(Kind kind, String literal, char unit, int width, String suffix, boolean hideWhenZero) {
        static Piece literal(String s) {
            return new Piece(Kind.LITERAL, s, '\u0000', 0, "", false);
        }

        static Piece unit(char unit, int width, String suffix, boolean hideWhenZero) {
            return new Piece(Kind.UNIT, "", unit, width, suffix, hideWhenZero);
        }
    }

    private static enum Kind {
        LITERAL,
        UNIT;

    }
}

