/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import top.ourisland.invertotimer.config.model.ActionConfig;
import top.ourisland.invertotimer.config.model.ServerLimitation;
import top.ourisland.invertotimer.config.model.ShowcaseConfig;
import top.ourisland.invertotimer.util.YamlUtil;

public record TimerConfig(String id, String description, String cron, String time, ServerLimitation limitation, Map<String, ShowcaseConfig> showcases, List<ActionConfig> actions) {
    public static TimerConfig fromYaml(String id, Map<?, ?> m) {
        String desc = YamlUtil.getString(m, "description", id);
        String cron = m.get("cron") == null ? null : String.valueOf(m.get("cron"));
        String time = m.get("time") == null ? null : String.valueOf(m.get("time"));
        ServerLimitation lim = ServerLimitation.fromYaml(m.get("limitation"));
        LinkedHashMap<String, ShowcaseConfig> showcases = new LinkedHashMap<String, ShowcaseConfig>();
        Object scObj = m.get("showcases");
        if (scObj instanceof Map) {
            Map scm = (Map)scObj;
            for (Map.Entry e : scm.entrySet()) {
                showcases.put(String.valueOf(e.getKey()), ShowcaseConfig.fromYaml(e.getValue()));
            }
        }
        ArrayList<ActionConfig> actions = new ArrayList<ActionConfig>();
        Object actObj = m.get("actions");
        if (actObj instanceof List) {
            List list = (List)actObj;
            for (Object o : list) {
                ActionConfig ac = ActionConfig.fromYaml(o);
                if (ac == null) continue;
                actions.add(ac);
            }
        }
        return new TimerConfig(id, desc, cron, time, lim, showcases, actions);
    }
}

