/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import top.ourisland.invertotimer.util.TimeUtil;

public record ShowcaseConfig(boolean enabled, Duration startAt, Duration interval, Object text, String color, After after) {
    public static ShowcaseConfig fromYaml(Object obj) {
        if (!(obj instanceof Map)) {
            return null;
        }
        Map m = (Map)obj;
        boolean enabled = true;
        Object enabledRaw = m.get("enabled");
        if (enabledRaw instanceof Boolean) {
            Boolean b = (Boolean)enabledRaw;
            enabled = b;
        } else if (enabledRaw != null) {
            enabled = Boolean.parseBoolean(String.valueOf(enabledRaw));
        }
        Duration startAt = TimeUtil.parseDurationLoose(m.get("start-at"));
        Duration interval = TimeUtil.parseDurationLoose(m.get("interval"));
        Object text = m.get("text");
        if (text == null && (m.containsKey("title") || m.containsKey("subtitle"))) {
            String t = m.get("title") == null ? "" : String.valueOf(m.get("title"));
            String s = m.get("subtitle") == null ? "" : String.valueOf(m.get("subtitle"));
            ArrayList<String> list = new ArrayList<String>();
            list.add(t);
            list.add(s);
            text = list;
        }
        String color = m.get("color") == null ? null : String.valueOf(m.get("color"));
        After after = null;
        Object afterObj = m.get("after");
        if (afterObj instanceof Map) {
            Map am = (Map)afterObj;
            Object at = am.get("text");
            Duration dur = TimeUtil.parseDurationLoose(am.get("duration"));
            if (dur == null) {
                dur = Duration.ZERO;
            }
            if (at != null || !dur.isZero()) {
                after = new After(at, dur);
            }
        }
        return new ShowcaseConfig(enabled, startAt, interval, text, color, after);
    }

    public record After(Object text, Duration duration) {
    }
}

