/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import top.ourisland.invertotimer.util.YamlUtil;

public record AnimationConfig(String id, List<Frame> frames, long totalDurationMs) {
    public static AnimationConfig fromYaml(String id, Map<?, ?> m) {
        List framesList;
        if (m == null) {
            return new AnimationConfig(id, List.of(new Frame(1000L, "")), 1000L);
        }
        Object framesObj = m.get("frames");
        if (framesObj instanceof List && !(framesList = (List)framesObj).isEmpty()) {
            ArrayList<Frame> frames = new ArrayList<Frame>();
            long total = 0L;
            for (Object o : framesList) {
                if (!(o instanceof Map)) continue;
                Map fm = (Map)o;
                double durSec = YamlUtil.getDouble(fm, "duration", 1.0);
                long durMs = Math.max(1L, Math.round(durSec * 1000.0));
                String text = YamlUtil.getString(fm, "text", "");
                frames.add(new Frame(durMs, text));
                total += durMs;
            }
            if (frames.isEmpty()) {
                return new AnimationConfig(id, List.of(new Frame(1000L, "")), 1000L);
            }
            return new AnimationConfig(id, List.copyOf(frames), Math.max(1L, total));
        }
        double intervalSec = YamlUtil.getDouble(m, "interval", 1.0);
        long intervalMs = Math.max(1L, Math.round(intervalSec * 1000.0));
        Object textObj = m.get("text");
        ArrayList<Frame> frames = new ArrayList<Frame>();
        if (textObj instanceof List) {
            List texts = (List)textObj;
            for (Object o : texts) {
                frames.add(new Frame(intervalMs, o == null ? "" : String.valueOf(o)));
            }
        } else if (textObj != null) {
            frames.add(new Frame(intervalMs, String.valueOf(textObj)));
        }
        if (frames.isEmpty()) {
            frames.add(new Frame(intervalMs, ""));
        }
        long total = intervalMs * (long)frames.size();
        return new AnimationConfig(id, List.copyOf(frames), Math.max(1L, total));
    }

    public record Frame(long durationMs, String text) {
    }
}

