/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import top.ourisland.invertotimer.config.model.AnimationConfig;
import top.ourisland.invertotimer.config.model.GlobalConfig;
import top.ourisland.invertotimer.config.model.TimerConfig;
import top.ourisland.invertotimer.util.YamlUtil;

public class ConfigManager {
    private final Logger logger;
    private final Path dataDir;
    private GlobalConfig globalConfig = GlobalConfig.defaults();
    private Map<String, TimerConfig> timers = new LinkedHashMap<String, TimerConfig>();
    private Map<String, AnimationConfig> animations = new LinkedHashMap<String, AnimationConfig>();

    public ConfigManager(Logger logger, Path dataDir) {
        this.logger = logger;
        this.dataDir = dataDir;
    }

    public void reloadAll() {
        try {
            Files.createDirectories(this.dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.error("Cannot create data directory: {}", (Object)this.dataDir, (Object)e);
        }
        this.copyDefaultIfAbsent("config.yml");
        this.copyDefaultIfAbsent("timer.yml");
        this.copyDefaultIfAbsent("animations.yml");
        this.globalConfig = this.loadGlobal();
        this.timers = this.loadTimers();
        this.animations = this.loadAnimations();
    }

    private void copyDefaultIfAbsent(String filename) {
        Path dest = this.dataDir.resolve(filename);
        if (Files.exists(dest, new LinkOption[0])) {
            return;
        }
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(filename);){
            if (in == null) {
                this.logger.warn("Default resource {} not found in jar, creating empty file.", (Object)filename);
                Files.writeString(dest, (CharSequence)("# " + filename + "\n"), new OpenOption[0]);
                return;
            }
            Files.copy(in, dest, new CopyOption[0]);
            this.logger.info("Generated default {}", (Object)dest.getFileName());
        }
        catch (IOException e) {
            this.logger.error("Failed to generate default {}", (Object)filename, (Object)e);
        }
    }

    private GlobalConfig loadGlobal() {
        Path p = this.dataDir.resolve("config.yml");
        try {
            Object root = YamlUtil.parse(Files.readString(p));
            if (!(root instanceof Map)) {
                this.logger.warn("config.yml root is not a map, using defaults.");
                return GlobalConfig.defaults();
            }
            Map m = (Map)root;
            return GlobalConfig.fromYaml(m);
        }
        catch (Exception e) {
            this.logger.error("Failed to load config.yml, using defaults.", (Throwable)e);
            return GlobalConfig.defaults();
        }
    }

    private Map<String, TimerConfig> loadTimers() {
        Path p = this.dataDir.resolve("timer.yml");
        try {
            Object root = YamlUtil.parse(Files.readString(p));
            if (!(root instanceof Map)) {
                this.logger.warn("timer.yml root is not a map.");
                return new LinkedHashMap<String, TimerConfig>();
            }
            Map m = (Map)root;
            Object timersObj = m.get("timers");
            if (!(timersObj instanceof Map)) {
                this.logger.warn("timer.yml missing 'timers:' root map.");
                return new LinkedHashMap<String, TimerConfig>();
            }
            Map timersMap = (Map)timersObj;
            LinkedHashMap<String, TimerConfig> out = new LinkedHashMap<String, TimerConfig>();
            for (Map.Entry e : timersMap.entrySet()) {
                String id = String.valueOf(e.getKey());
                Object v = e.getValue();
                if (!(v instanceof Map)) continue;
                Map tm = (Map)v;
                out.put(id, TimerConfig.fromYaml(id, tm));
            }
            return out;
        }
        catch (Exception e) {
            this.logger.error("Failed to load timer.yml", (Throwable)e);
            return new LinkedHashMap<String, TimerConfig>();
        }
    }

    private Map<String, AnimationConfig> loadAnimations() {
        Path p = this.dataDir.resolve("animations.yml");
        if (!Files.exists(p, new LinkOption[0])) {
            return new LinkedHashMap<String, AnimationConfig>();
        }
        try {
            Object root = YamlUtil.parse(Files.readString(p));
            if (!(root instanceof Map)) {
                this.logger.warn("{} root is not a map.", (Object)p.getFileName());
                return new LinkedHashMap<String, AnimationConfig>();
            }
            Map m = (Map)root;
            Object animationsObj = m.get("animations");
            if (!(animationsObj instanceof Map)) {
                this.logger.warn("{} missing 'animations:' root map.", (Object)p.getFileName());
                return new LinkedHashMap<String, AnimationConfig>();
            }
            Map animationsMap = (Map)animationsObj;
            LinkedHashMap<String, AnimationConfig> out = new LinkedHashMap<String, AnimationConfig>();
            for (Map.Entry e : animationsMap.entrySet()) {
                String id = String.valueOf(e.getKey());
                Object v = e.getValue();
                if (!(v instanceof Map)) continue;
                Map am = (Map)v;
                out.put(id, AnimationConfig.fromYaml(id, am));
            }
            return out;
        }
        catch (Exception e) {
            this.logger.error("Failed to load {}", (Object)p.getFileName(), (Object)e);
            return new LinkedHashMap<String, AnimationConfig>();
        }
    }

    public Map<String, TimerConfig> getTimers() {
        return Collections.unmodifiableMap(this.timers);
    }

    @Generated
    public GlobalConfig globalConfig() {
        return this.globalConfig;
    }

    @Generated
    public Map<String, AnimationConfig> animations() {
        return this.animations;
    }
}

