/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.action;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;

public class TransferAction
implements Action {
    private final RuntimeContext ctx;
    private final String target;
    private final Pattern transfereePattern;

    public TransferAction(@NonNull RuntimeContext ctx, String target, String transfereeRegex) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.ctx = ctx;
        this.target = target == null ? "" : target;
        String rx = transfereeRegex == null || transfereeRegex.isBlank() ? ".*" : transfereeRegex;
        this.transfereePattern = TransferAction.compileOrSafeNone(rx);
    }

    private static Pattern compileOrSafeNone(String rx) {
        try {
            return Pattern.compile(rx);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public String name() {
        return "transfer";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.action.transfer.desc");
    }

    @Override
    public void execute() {
        if (this.target.isBlank() || this.transfereePattern == null) {
            return;
        }
        Optional serverOpt = this.ctx.proxy().getServer(this.target);
        if (serverOpt.isEmpty()) {
            this.ctx.logger().warn("");
            return;
        }
        this.ctx.players().stream().filter(this.ctx::allowed).filter(p -> this.transfereePattern.matcher(p.getUsername()).matches()).forEach(p -> p.createConnectionRequest((RegisteredServer)serverOpt.get()).connect().thenAccept(result -> {
            if (!result.isSuccessful()) {
                Component reasonComp = (Component)result.getReasonComponent().orElse(Component.text((String)("Unknown reason (Status: " + String.valueOf(result.getStatus()) + ")")));
                String reasonStr = PlainTextComponentSerializer.plainText().serialize(reasonComp);
                this.ctx.logger().warn("Failed to transfer player {}: {}", (Object)p.getUsername(), (Object)reasonStr);
                p.sendMessage(I18n.withPrefixComp(reasonStr));
            }
        }));
    }
}

