/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.action;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.regex.Pattern;
import lombok.NonNull;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;

public class CommandAction
implements Action {
    private final RuntimeContext ctx;
    private final Executor executor;
    private final String command;
    private final Pattern match;

    public CommandAction(@NonNull RuntimeContext ctx, Executor executor, String command, String matchRegex) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.ctx = ctx;
        this.executor = executor == null ? Executor.PLAYER : executor;
        this.command = command == null ? "" : command;
        Pattern compiled = null;
        if (this.executor == Executor.PLAYER && matchRegex != null && !matchRegex.isBlank()) {
            try {
                compiled = Pattern.compile(matchRegex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.match = compiled;
    }

    public static Executor parse(String s) {
        if (s == null) {
            return Executor.PLAYER;
        }
        return "console".equalsIgnoreCase(s) ? Executor.CONSOLE : Executor.PLAYER;
    }

    @Override
    public String name() {
        return "command";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.action.command.desc");
    }

    @Override
    public void execute() {
        switch (this.executor.ordinal()) {
            case 0: {
                String cmd = this.ctx.renderString(this.command).trim();
                if (cmd.isBlank()) {
                    return;
                }
                this.ctx.proxy().getCommandManager().executeAsync((CommandSource)this.ctx.proxy().getConsoleCommandSource(), CommandAction.trimLeadingSlash(cmd));
                break;
            }
            case 1: {
                this.ctx.players().stream().filter(this.ctx::allowed).filter(p -> this.match == null || this.match.matcher(p.getUsername()).matches()).forEach(p -> {
                    String cmd = this.ctx.renderString((Player)p, this.command).trim();
                    if (cmd.isBlank()) {
                        return;
                    }
                    p.spoofChatInput(cmd);
                });
            }
        }
    }

    private static String trimLeadingSlash(String cmd) {
        String s = cmd.trim();
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public static enum Executor {
        CONSOLE,
        PLAYER;

    }
}

