/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import top.ourisland.invertotimer.config.ConfigManager;
import top.ourisland.invertotimer.config.model.TimerConfig;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.timer.TimerRunner;

@Plugin(id="invertotimer", name="invertoTimer", version="0.2.0", description="A Velocity countdown timer plugin.", url="https://github.com/Our-Island/invertoTimer", authors={"Our-Island", "Chiloven945"}, dependencies={@Dependency(id="miniplaceholders", optional=true)})
public class InvertoTimer {
    private final ProxyServer proxy;
    private final Logger logger;
    private final Path dataDir;
    private ConfigManager configManager;
    private TimerRunner timerRunner;

    @Inject
    public InvertoTimer(ProxyServer proxy, Logger logger, @DataDirectory Path dataDir) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataDir = dataDir;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.logger.info("Initializing invertoTimer {}...", (Object)"0.2.0");
            this.configManager = new ConfigManager(this.logger, this.dataDir);
            this.configManager.reloadAll();
            I18n.init(this.configManager, this.logger);
            this.timerRunner = new TimerRunner(this, this.proxy, this.logger, this.configManager);
            this.timerRunner.start();
            this.proxy.getEventManager().register((Object)this, (Object)this.timerRunner);
            this.registerCommands();
            this.logger.info("invertoTimer loaded: {} timer(s).", (Object)this.configManager.getTimers().size());
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize invertoTimer", (Throwable)e);
        }
    }

    private void registerCommands() {
        CommandManager cm = this.proxy.getCommandManager();
        CommandMeta meta = cm.metaBuilder("invertotimer").aliases(new String[]{"itimer", "invttimer"}).plugin((Object)this).build();
        cm.register(meta, (Command)new RootCommand(this));
    }

    public void reload() {
        this.configManager.reloadAll();
        this.timerRunner.reloadFromConfig();
        this.logger.info("invertoTimer reloaded: {} timer(s).", (Object)this.configManager.getTimers().size());
    }

    private record RootCommand(InvertoTimer plugin) implements SimpleCommand
    {
        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource src = invocation.source();
            String[] args = (String[])invocation.arguments();
            if (!src.hasPermission("invertotimer.admin")) {
                src.sendMessage(I18n.lang("itimer.command.no_perms"));
                return;
            }
            if (args.length == 0) {
                src.sendMessage(I18n.lang("itimer.command.usage", "/itimer <reload|list|status>"));
                return;
            }
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "reload": {
                    this.plugin.reload();
                    src.sendMessage(I18n.lang("itimer.command.reload"));
                    break;
                }
                case "list": 
                case "status": {
                    Map<String, TimerConfig> timers = this.plugin.configManager.getTimers();
                    if (timers.isEmpty()) {
                        src.sendMessage(I18n.lang("itimer.command.list.failed"));
                        return;
                    }
                    src.sendMessage(I18n.lang("itimer.command.list.header"));
                    timers.forEach((id, cfg) -> {
                        String next = this.plugin.timerRunner.peekNextOccurrence((String)id);
                        src.sendMessage((Component)Component.text((String)(" - " + id + " : " + (next == null ? "N/A" : next))));
                    });
                    break;
                }
                default: {
                    src.sendMessage(I18n.lang("itimer.command.usage", "/itimer <reload|list|status>"));
                }
            }
        }
    }
}

