/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.showcase;

import com.velocitypowered.api.proxy.Player;
import java.util.Locale;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;
import top.ourisland.invertotimer.showcase.Showcase;

public class BossbarShowcase
implements Showcase {
    private final RuntimeContext ctx;
    private final Supplier<Object> textSupplier;
    private final BossBar bossBar;
    private final Supplier<Float> progressSupplier;

    public BossbarShowcase(RuntimeContext ctx, Supplier<Object> textSupplier, Supplier<Float> progressSupplier, String colorName) {
        this.ctx = ctx;
        this.textSupplier = textSupplier;
        this.progressSupplier = progressSupplier;
        BossBar.Color color = BossbarShowcase.parseColor(colorName);
        this.bossBar = BossBar.bossBar((Component)Component.empty(), (float)1.0f, (BossBar.Color)color, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
    }

    private static BossBar.Color parseColor(String s) {
        if (s == null) {
            return BossBar.Color.BLUE;
        }
        return switch (s.toLowerCase(Locale.ROOT)) {
            case "pink" -> BossBar.Color.PINK;
            case "red" -> BossBar.Color.RED;
            case "green" -> BossBar.Color.GREEN;
            case "yellow" -> BossBar.Color.YELLOW;
            case "purple" -> BossBar.Color.PURPLE;
            case "white" -> BossBar.Color.WHITE;
            default -> BossBar.Color.BLUE;
        };
    }

    @Override
    public String name() {
        return "bossbar";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.showcase.bossbar.desc");
    }

    @Override
    public void show() {
        this.bossBar.name(this.ctx.render(String.valueOf(this.textSupplier.get())));
        float p = this.progressSupplier.get().floatValue();
        if (p < 0.0f) {
            p = 0.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        this.bossBar.progress(p);
        for (Player p0 : this.ctx.players()) {
            if (!this.ctx.allowed(p0)) {
                p0.hideBossBar(this.bossBar);
                continue;
            }
            p0.showBossBar(this.bossBar);
        }
    }

    public void showTo(Player p) {
        if (!this.ctx.allowed(p)) {
            return;
        }
        this.bossBar.name(this.ctx.render(String.valueOf(this.textSupplier.get())));
        float prog = this.progressSupplier.get().floatValue();
        if (prog < 0.0f) {
            prog = 0.0f;
        }
        if (prog > 1.0f) {
            prog = 1.0f;
        }
        this.bossBar.progress(prog);
        p.showBossBar(this.bossBar);
    }

    public void hideFrom(Player p) {
        p.hideBossBar(this.bossBar);
    }
}

