/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.timer;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import top.ourisland.invertotimer.InvertoTimer;
import top.ourisland.invertotimer.config.ConfigManager;
import top.ourisland.invertotimer.config.model.GlobalConfig;
import top.ourisland.invertotimer.config.model.TimerConfig;
import top.ourisland.invertotimer.runtime.timer.TimerInstance;

public class TimerRunner {
    private final InvertoTimer plugin;
    private final ProxyServer proxy;
    private final Logger logger;
    private final ConfigManager configs;
    private final Map<String, TimerInstance> instances = new HashMap<String, TimerInstance>();
    private volatile GlobalConfig global;
    private volatile Map<String, TimerConfig> timerConfigs;
    private ScheduledTask tickTask;

    public TimerRunner(InvertoTimer plugin, ProxyServer proxy, Logger logger, ConfigManager configs) {
        this.plugin = plugin;
        this.proxy = proxy;
        this.logger = logger;
        this.configs = configs;
        this.reloadFromConfig();
    }

    public synchronized void reloadFromConfig() {
        this.instances.values().forEach(TimerInstance::dispose);
        this.global = this.configs.getGlobalConfig();
        this.timerConfigs = this.configs.getTimers();
        this.instances.clear();
        for (String id : this.timerConfigs.keySet()) {
            this.instances.put(id, new TimerInstance(this.plugin, this.proxy, this.logger, this.timerConfigs.get(id), this.global.zoneId()));
        }
    }

    public synchronized void start() {
        if (this.tickTask != null) {
            this.tickTask.cancel();
        }
        this.tickTask = this.proxy.getScheduler().buildTask((Object)this.plugin, this::tick).repeat(250L, TimeUnit.MILLISECONDS).schedule();
    }

    private void tick() {
        Instant now = Instant.now();
        GlobalConfig g = this.global;
        for (TimerInstance inst : this.instances.values()) {
            inst.tick(now, g);
        }
    }

    public String peekNextOccurrence(String timerId) {
        TimerInstance inst = this.instances.get(timerId);
        return inst == null ? null : inst.peekNext();
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent e) {
        Player p = e.getPlayer();
        for (TimerInstance inst : this.instances.values()) {
            inst.refreshFor(p);
        }
    }

    @Subscribe
    public void onServerConnected(ServerConnectedEvent e) {
        Player p = e.getPlayer();
        for (TimerInstance inst : this.instances.values()) {
            inst.refreshFor(p);
        }
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent e) {
        Player p = e.getPlayer();
        for (TimerInstance inst : this.instances.values()) {
            inst.hideFor(p);
        }
    }
}

