/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.timer;

import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.util.Locale;

public class Cron5 {
    private final Field minute;
    private final Field hour;
    private final Field dayOfMonth;
    private final Field month;
    private final Field dayOfWeek;

    private Cron5(Field minute, Field hour, Field dayOfMonth, Field month, Field dayOfWeek) {
        this.minute = minute;
        this.hour = hour;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.dayOfWeek = dayOfWeek;
    }

    public static Cron5 parse(String expr) {
        if (expr == null) {
            return null;
        }
        String[] parts = expr.trim().split("\\s+");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Cron must have 5 fields.");
        }
        return new Cron5(Field.parse(parts[0]), Field.parse(parts[1]), Field.parse(parts[2]), Field.parse(parts[3]), Field.parse(parts[4]));
    }

    public ZonedDateTime nextAfter(ZonedDateTime after) {
        ZonedDateTime t = after.plusMinutes(1L).withSecond(0).withNano(0);
        for (int i = 0; i < 5270400; ++i) {
            if (this.matches(t)) {
                return t;
            }
            t = t.plusMinutes(1L);
        }
        return null;
    }

    private boolean matches(ZonedDateTime zdt) {
        int min = zdt.getMinute();
        int hr = zdt.getHour();
        int dom = zdt.getDayOfMonth();
        int mon = zdt.getMonthValue();
        int dow = zdt.getDayOfWeek().getValue();
        return this.minute.matches(min) && this.hour.matches(hr) && this.dayOfMonth.matches(dom) && this.month.matches(mon) && this.dayOfWeek.matches(dow);
    }

    private record Field(boolean any, Integer value) {
        static Field parse(String s) {
            if ((s = s.trim().toLowerCase(Locale.ROOT)).equals("*")) {
                return new Field(true, null);
            }
            return new Field(false, Integer.parseInt(s));
        }

        boolean matches(int v) {
            if (this.any) {
                return true;
            }
            if (this.value == null) {
                return false;
            }
            if (this.value == 0 && v == DayOfWeek.SUNDAY.getValue()) {
                return true;
            }
            if (this.value == 7 && v == DayOfWeek.SUNDAY.getValue()) {
                return true;
            }
            return this.value == v;
        }
    }
}

