/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import top.ourisland.invertotimer.runtime.TextRenderer;

public final class RuntimeContext {
    private final ProxyServer proxy;
    private final Predicate<Player> allowed;
    private final Function<String, String> placeholder;

    public RuntimeContext(ProxyServer proxy, Predicate<Player> allowed, Function<String, String> placeholder) {
        this.proxy = Objects.requireNonNull(proxy);
        this.allowed = Objects.requireNonNull(allowed);
        this.placeholder = Objects.requireNonNull(placeholder);
    }

    public ProxyServer proxy() {
        return this.proxy;
    }

    public Collection<Player> players() {
        return this.proxy.getAllPlayers();
    }

    public boolean allowed(Player p) {
        return this.allowed.test(p);
    }

    public Component render(String text) {
        return TextRenderer.renderToComponent(text, this.placeholder);
    }

    public String renderString(String text) {
        return this.placeholder.apply(TextRenderer.replaceI18n(text));
    }
}

