/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import top.ourisland.invertotimer.config.SimpleYaml;
import top.ourisland.invertotimer.config.model.GlobalConfig;
import top.ourisland.invertotimer.config.model.TimerConfig;

public class ConfigManager {
    private final Logger logger;
    private final Path dataDir;
    private GlobalConfig globalConfig = GlobalConfig.defaults();
    private Map<String, TimerConfig> timers = new LinkedHashMap<String, TimerConfig>();

    public ConfigManager(Logger logger, Path dataDir) {
        this.logger = logger;
        this.dataDir = dataDir;
    }

    public void reloadAll() {
        try {
            Files.createDirectories(this.dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.error("Cannot create data directory: {}", (Object)this.dataDir, (Object)e);
        }
        this.copyDefaultIfAbsent("config.yml");
        this.copyDefaultIfAbsent("timer.yml");
        this.globalConfig = this.loadGlobal();
        this.timers = this.loadTimers();
    }

    private void copyDefaultIfAbsent(String filename) {
        Path dest = this.dataDir.resolve(filename);
        if (Files.exists(dest, new LinkOption[0])) {
            return;
        }
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(filename);){
            if (in == null) {
                this.logger.warn("Default resource {} not found in jar, creating empty file.", (Object)filename);
                Files.writeString(dest, (CharSequence)("# " + filename + "\n"), new OpenOption[0]);
                return;
            }
            Files.copy(in, dest, new CopyOption[0]);
            this.logger.info("Generated default {}", (Object)dest.getFileName());
        }
        catch (IOException e) {
            this.logger.error("Failed to generate default " + filename, (Throwable)e);
        }
    }

    private GlobalConfig loadGlobal() {
        Path p = this.dataDir.resolve("config.yml");
        try {
            Object root = SimpleYaml.parse(Files.readString(p));
            if (!(root instanceof Map)) {
                this.logger.warn("config.yml root is not a map, using defaults.");
                return GlobalConfig.defaults();
            }
            Map m = (Map)root;
            return GlobalConfig.fromYaml(m);
        }
        catch (Exception e) {
            this.logger.error("Failed to load config.yml, using defaults.", (Throwable)e);
            return GlobalConfig.defaults();
        }
    }

    private Map<String, TimerConfig> loadTimers() {
        Path p = this.dataDir.resolve("timer.yml");
        try {
            Object root = SimpleYaml.parse(Files.readString(p));
            if (!(root instanceof Map)) {
                this.logger.warn("timer.yml root is not a map.");
                return new LinkedHashMap<String, TimerConfig>();
            }
            Map m = (Map)root;
            Object timersObj = m.get("timers");
            if (!(timersObj instanceof Map)) {
                this.logger.warn("timer.yml missing 'timers:' root map.");
                return new LinkedHashMap<String, TimerConfig>();
            }
            Map timersMap = (Map)timersObj;
            LinkedHashMap<String, TimerConfig> out = new LinkedHashMap<String, TimerConfig>();
            for (Map.Entry e : timersMap.entrySet()) {
                String id = String.valueOf(e.getKey());
                Object v = e.getValue();
                if (!(v instanceof Map)) continue;
                Map tm = (Map)v;
                out.put(id, TimerConfig.fromYaml(id, tm));
            }
            return out;
        }
        catch (Exception e) {
            this.logger.error("Failed to load timer.yml", (Throwable)e);
            return new LinkedHashMap<String, TimerConfig>();
        }
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public Map<String, TimerConfig> getTimers() {
        return Collections.unmodifiableMap(this.timers);
    }
}

