/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.action;

import com.velocitypowered.api.proxy.Player;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;

public class TextAction
implements Action {
    private final RuntimeContext ctx;
    private final TextType textType;
    private final String info;
    private final String title;
    private final String subtitle;
    private final Duration fadeIn;
    private final Duration stay;
    private final Duration fadeOut;

    public TextAction(RuntimeContext ctx, TextType textType, Object infoRaw) {
        this.ctx = Objects.requireNonNull(ctx);
        this.textType = Objects.requireNonNull(textType);
        Duration fi = null;
        Duration st = null;
        Duration fo = null;
        if (textType == TextType.TITLE || textType == TextType.SUBTITLE) {
            String t = "";
            String s = "";
            if (infoRaw instanceof List) {
                List list = (List)infoRaw;
                if (!list.isEmpty()) {
                    t = String.valueOf(list.get(0));
                }
                if (list.size() > 1) {
                    s = String.valueOf(list.get(1));
                }
                if (list.size() > 2) {
                    fi = TextAction.parseSecondsToDuration(list.get(2));
                }
                if (list.size() > 3) {
                    st = TextAction.parseSecondsToDuration(list.get(3));
                }
                if (list.size() > 4) {
                    fo = TextAction.parseSecondsToDuration(list.get(4));
                }
            } else if (infoRaw instanceof Object[]) {
                Object[] arr = (Object[])infoRaw;
                if (arr.length > 0) {
                    t = String.valueOf(arr[0]);
                }
                if (arr.length > 1) {
                    s = String.valueOf(arr[1]);
                }
                if (arr.length > 2) {
                    fi = TextAction.parseSecondsToDuration(arr[2]);
                }
                if (arr.length > 3) {
                    st = TextAction.parseSecondsToDuration(arr[3]);
                }
                if (arr.length > 4) {
                    fo = TextAction.parseSecondsToDuration(arr[4]);
                }
            } else if (infoRaw != null) {
                if (textType == TextType.TITLE) {
                    t = String.valueOf(infoRaw);
                    s = "";
                } else {
                    t = "";
                    s = String.valueOf(infoRaw);
                }
            }
            this.title = t == null ? "" : t;
            this.subtitle = s == null ? "" : s;
            this.info = "";
            this.fadeIn = fi;
            this.stay = st;
            this.fadeOut = fo;
        } else {
            this.info = infoRaw == null ? "" : String.valueOf(infoRaw);
            this.title = "";
            this.subtitle = "";
            this.fadeIn = null;
            this.stay = null;
            this.fadeOut = null;
        }
    }

    private static Duration parseSecondsToDuration(Object o) {
        if (o == null) {
            return null;
        }
        try {
            if (o instanceof Number) {
                Number n = (Number)o;
                long sec = n.longValue();
                if (sec < 0L) {
                    sec = 0L;
                }
                return Duration.ofSeconds(sec);
            }
            String s = String.valueOf(o).trim();
            if (s.isEmpty()) {
                return null;
            }
            long sec = Long.parseLong(s);
            if (sec < 0L) {
                sec = 0L;
            }
            return Duration.ofSeconds(sec);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static TextType parse(String s) {
        if (s == null) {
            return TextType.MESSAGE;
        }
        return switch (s.toLowerCase(Locale.ROOT)) {
            case "actionbar" -> TextType.ACTIONBAR;
            case "title" -> TextType.TITLE;
            case "subtitle" -> TextType.SUBTITLE;
            default -> TextType.MESSAGE;
        };
    }

    @Override
    public String name() {
        return "text";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.action.text.desc");
    }

    @Override
    public void execute() {
        for (Player p : this.ctx.players()) {
            if (!this.ctx.allowed(p)) continue;
            switch (this.textType.ordinal()) {
                case 1: {
                    p.sendActionBar(this.ctx.render(this.info));
                    break;
                }
                case 0: {
                    p.sendMessage(this.ctx.render(this.info));
                    break;
                }
                case 2: 
                case 3: {
                    Component t = this.ctx.render(this.title);
                    Component s = this.ctx.render(this.subtitle);
                    if (this.fadeIn != null || this.stay != null || this.fadeOut != null) {
                        Duration fi = this.fadeIn != null ? this.fadeIn : Duration.of(0L, ChronoUnit.SECONDS);
                        Duration st = this.stay != null ? this.stay : Duration.of(2L, ChronoUnit.SECONDS);
                        Duration fo = this.fadeOut != null ? this.fadeOut : Duration.of(0L, ChronoUnit.SECONDS);
                        p.showTitle(Title.title((Component)t, (Component)s, (Title.Times)Title.Times.times((Duration)fi, (Duration)st, (Duration)fo)));
                        break;
                    }
                    p.showTitle(Title.title((Component)t, (Component)s));
                }
            }
        }
    }

    public static enum TextType {
        MESSAGE,
        ACTIONBAR,
        TITLE,
        SUBTITLE;

    }
}

