/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.showcase;

import com.velocitypowered.api.proxy.Player;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;
import top.ourisland.invertotimer.showcase.Showcase;

public class BossbarShowcase
implements Showcase {
    private final RuntimeContext ctx;
    private final String text;
    private final BossBar bossBar;
    private final Supplier<Float> progressSupplier;

    public BossbarShowcase(RuntimeContext ctx, String text, Supplier<Float> progressSupplier) {
        this.ctx = ctx;
        this.text = text;
        this.progressSupplier = progressSupplier;
        this.bossBar = BossBar.bossBar((Component)Component.empty(), (float)1.0f, (BossBar.Color)BossBar.Color.BLUE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
    }

    @Override
    public String name() {
        return "bossbar";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.showcase.bossbar.desc");
    }

    @Override
    public void show() {
        this.bossBar.name(this.ctx.render(this.text));
        float p = this.progressSupplier.get().floatValue();
        if (p < 0.0f) {
            p = 0.0f;
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        this.bossBar.progress(p);
        for (Player p0 : this.ctx.players()) {
            if (!this.ctx.allowed(p0)) {
                p0.hideBossBar(this.bossBar);
                continue;
            }
            p0.showBossBar(this.bossBar);
        }
    }

    public void showTo(Player p) {
        if (!this.ctx.allowed(p)) {
            return;
        }
        this.bossBar.name(this.ctx.render(this.text));
        this.bossBar.progress(this.progressSupplier.get().floatValue());
        p.showBossBar(this.bossBar);
    }

    public void hideFrom(Player p) {
        p.hideBossBar(this.bossBar);
    }
}

