/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.timer;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.config.model.ActionConfig;
import top.ourisland.invertotimer.config.model.GlobalConfig;
import top.ourisland.invertotimer.config.model.ShowcaseConfig;
import top.ourisland.invertotimer.config.model.TimerConfig;
import top.ourisland.invertotimer.runtime.RuntimeContext;
import top.ourisland.invertotimer.runtime.action.ActionFactory;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseFactory;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseSlot;
import top.ourisland.invertotimer.runtime.showcase.ShowcaseType;
import top.ourisland.invertotimer.runtime.timer.Cron5;
import top.ourisland.invertotimer.runtime.timer.TimeUtil;
import top.ourisland.invertotimer.showcase.BossbarShowcase;
import top.ourisland.invertotimer.showcase.Showcase;

final class TimerInstance {
    private static final DateTimeFormatter TIME_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ProxyServer proxy;
    private final Logger logger;
    private final TimerConfig cfg;
    private final ZoneId zoneId;
    private final List<ScheduledAction> scheduledActions = new ArrayList<ScheduledAction>();
    private final Map<String, ShowcaseSlot> showcaseSlots = new HashMap<String, ShowcaseSlot>();
    private Cron5 cron;
    private LocalDateTime oneTime;
    private ZonedDateTime nextTarget;
    private volatile GlobalConfig lastGlobal;
    private volatile Instant lastNow;
    private BossbarShowcase bossbarShowcase;
    private ShowcaseConfig bossBarConfig;
    private RuntimeContext ctx;

    TimerInstance(ProxyServer proxy, Logger logger, TimerConfig cfg, ZoneId zoneId) {
        this.proxy = proxy;
        this.logger = logger;
        this.cfg = cfg;
        this.zoneId = zoneId;
        this.parseTimeSpec();
        this.buildRuntimeContext();
        this.rebuildForNewTarget();
    }

    private void parseTimeSpec() {
        try {
            if (this.cfg.cron() != null && !this.cfg.cron().isBlank()) {
                this.cron = Cron5.parse(this.cfg.cron());
            }
        }
        catch (Exception ignored) {
            this.cron = null;
        }
        try {
            if (this.cfg.time() != null && !this.cfg.time().isBlank()) {
                this.oneTime = LocalDateTime.parse(this.cfg.time(), TIME_FMT);
            }
        }
        catch (Exception ignored) {
            this.oneTime = null;
        }
    }

    private void buildRuntimeContext() {
        this.ctx = new RuntimeContext(this.proxy, this::isPlayerAllowedUsingLastGlobal, s -> this.applyPlaceholders((String)s, this.lastNow == null ? Instant.now() : this.lastNow));
    }

    private void rebuildForNewTarget() {
        this.scheduledActions.clear();
        this.showcaseSlots.clear();
        this.bossbarShowcase = null;
        this.bossBarConfig = null;
        if (this.nextTarget == null) {
            return;
        }
        for (ActionConfig actionConfig : this.cfg.actions()) {
            Instant at = this.nextTarget.toInstant().plus(actionConfig.shift());
            Action action = ActionFactory.create(actionConfig, this.ctx);
            if (action == null) continue;
            this.scheduledActions.add(new ScheduledAction(at, action));
        }
        this.scheduledActions.sort(Comparator.comparing(a -> a.at));
        for (Map.Entry entry : this.cfg.showcases().entrySet()) {
            BossbarShowcase bbs;
            Showcase showcase;
            ShowcaseType kind;
            String key = (String)entry.getKey();
            ShowcaseConfig sc = (ShowcaseConfig)entry.getValue();
            if (sc == null || !sc.enabled() || (kind = ShowcaseType.fromKey(key)) == null || (showcase = ShowcaseFactory.create(key, sc, this.ctx, () -> Float.valueOf(this.progressFor(sc, this.lastNow == null ? Instant.now() : this.lastNow)))) == null) continue;
            ShowcaseSlot slot = new ShowcaseSlot(kind, sc, showcase);
            this.showcaseSlots.put(key.toLowerCase(Locale.ROOT), slot);
            if (!(showcase instanceof BossbarShowcase)) continue;
            this.bossbarShowcase = bbs = (BossbarShowcase)showcase;
            this.bossBarConfig = sc;
        }
    }

    private boolean isPlayerAllowedUsingLastGlobal(Player p) {
        GlobalConfig g = this.lastGlobal;
        if (g == null) {
            return true;
        }
        return this.isPlayerAllowed(p, g);
    }

    private String applyPlaceholders(String text, Instant now) {
        long remainingSec = this.nextTarget == null ? 0L : Math.max(0L, Duration.between(now, this.nextTarget.toInstant()).getSeconds());
        long days = remainingSec / 86400L;
        long rem = remainingSec % 86400L;
        long hours = rem / 3600L;
        long minutes = (rem %= 3600L) / 60L;
        long seconds = rem % 60L;
        String out = text == null ? "" : text;
        out = out.replace("{id}", this.cfg.id());
        out = out.replace("{description}", this.cfg.description());
        out = out.replace("{remaining}", TimeUtil.formatHMS(remainingSec));
        out = out.replace("{days}", String.valueOf(days));
        out = out.replace("{hours}", String.valueOf(hours));
        out = out.replace("{minutes}", String.valueOf(minutes));
        out = out.replace("{seconds}", String.valueOf(seconds));
        out = out.replace("{total_seconds}", String.valueOf(remainingSec));
        if (this.nextTarget != null) {
            out = out.replace("{target}", this.nextTarget.toString());
        }
        return out;
    }

    private float progressFor(ShowcaseConfig sc, Instant now) {
        if (this.nextTarget == null) {
            return 1.0f;
        }
        Instant target = this.nextTarget.toInstant();
        Duration startAt = sc.startAt();
        if (startAt != null && !startAt.isZero()) {
            float p;
            long total = startAt.abs().getSeconds();
            long rem = Math.max(0L, Duration.between(now, target).getSeconds());
            float f = p = total == 0L ? 0.0f : (float)rem / (float)total;
            if (p < 0.0f) {
                p = 0.0f;
            }
            if (p > 1.0f) {
                p = 1.0f;
            }
            return p;
        }
        long rem = Math.max(0L, Duration.between(now, target).getSeconds());
        return rem > 0L ? 1.0f : 0.0f;
    }

    private boolean isPlayerAllowed(Player p, GlobalConfig global) {
        String serverName = p.getCurrentServer().map(c -> c.getServerInfo().getName()).orElse(null);
        if (!global.limitation().isAllowed(serverName)) {
            return false;
        }
        return this.cfg.limitation().isAllowed(serverName);
    }

    void tick(Instant now, GlobalConfig global) {
        this.lastNow = now;
        this.lastGlobal = global;
        this.ensureNextTarget(now);
        this.runDueActions(now);
        this.updateShowcases(now);
    }

    void ensureNextTarget(Instant now) {
        if (this.nextTarget == null) {
            this.nextTarget = this.computeNextTarget(now);
            this.rebuildForNewTarget();
            return;
        }
        if (now.isAfter(this.getExpireTime())) {
            this.nextTarget = this.computeNextTarget(now);
            this.rebuildForNewTarget();
        }
    }

    private void runDueActions(Instant now) {
        if (this.nextTarget == null) {
            return;
        }
        for (ScheduledAction sa : this.scheduledActions) {
            if (sa.executed) continue;
            if (now.isBefore(sa.at)) break;
            try {
                sa.action.execute();
            }
            catch (Exception e) {
                this.logger.error("Failed executing action {} for timer {}", new Object[]{sa.action.name(), this.cfg.id(), e});
            }
            sa.executed = true;
        }
    }

    private void updateShowcases(Instant now) {
        if (this.nextTarget == null) {
            return;
        }
        long nowMs = now.toEpochMilli();
        for (ShowcaseSlot slot : this.showcaseSlots.values()) {
            if (!this.shouldShow(slot.config(), now)) continue;
            Duration interval = slot.config().interval();
            if (interval == null) {
                interval = slot.kind().defaultInterval();
            }
            if (!slot.tryAcquire(nowMs, interval.toMillis())) continue;
            try {
                slot.showcase().show();
            }
            catch (Exception e) {
                this.logger.error("Failed showing {} for timer {}", new Object[]{slot.showcase().name(), this.cfg.id(), e});
            }
        }
    }

    private ZonedDateTime computeNextTarget(Instant now) {
        ZonedDateTime zNow = ZonedDateTime.ofInstant(now, this.zoneId).withSecond(0).withNano(0);
        if (this.oneTime != null) {
            ZonedDateTime target = this.oneTime.atZone(this.zoneId);
            return target.isAfter(zNow) ? target : null;
        }
        if (this.cron != null) {
            return this.cron.nextAfter(zNow);
        }
        return null;
    }

    private Instant getExpireTime() {
        Instant lastAction = this.nextTarget == null ? Instant.EPOCH : this.nextTarget.toInstant();
        for (ScheduledAction a : this.scheduledActions) {
            if (!a.at.isAfter(lastAction)) continue;
            lastAction = a.at;
        }
        return lastAction.plusSeconds(2L);
    }

    private boolean shouldShow(ShowcaseConfig sc, Instant now) {
        if (this.nextTarget == null) {
            return false;
        }
        if (sc.startAt() == null) {
            return true;
        }
        Instant target = this.nextTarget.toInstant();
        Instant begin = target.minus(sc.startAt().abs());
        return !now.isBefore(begin);
    }

    String peekNext() {
        return this.nextTarget == null ? null : this.nextTarget.toString();
    }

    void refreshFor(Player p) {
        Instant now;
        if (this.bossbarShowcase == null || this.bossBarConfig == null) {
            return;
        }
        Instant instant = now = this.lastNow == null ? Instant.now() : this.lastNow;
        if (this.nextTarget == null) {
            return;
        }
        if (!this.shouldShow(this.bossBarConfig, now)) {
            this.bossbarShowcase.hideFrom(p);
            return;
        }
        if (!this.isPlayerAllowedUsingLastGlobal(p)) {
            this.bossbarShowcase.hideFrom(p);
            return;
        }
        this.bossbarShowcase.showTo(p);
    }

    void hideFor(Player p) {
        if (this.bossbarShowcase != null) {
            this.bossbarShowcase.hideFrom(p);
        }
    }

    private static final class ScheduledAction {
        final Instant at;
        final Action action;
        boolean executed;

        ScheduledAction(Instant at, Action action) {
            this.at = at;
            this.action = action;
        }
    }
}

