/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.timer;

import java.time.Duration;
import java.util.Locale;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static Duration parseDurationLoose(Object obj) {
        Duration d;
        long n;
        if (obj == null) {
            return null;
        }
        String s0 = String.valueOf(obj).trim();
        if (s0.isEmpty()) {
            return null;
        }
        String s = s0.toLowerCase(Locale.ROOT);
        boolean neg = false;
        if (s.startsWith("-")) {
            neg = true;
            s = s.substring(1).trim();
        } else if (s.startsWith("+")) {
            s = s.substring(1).trim();
        }
        if (s.isEmpty()) {
            return null;
        }
        char unit = s.charAt(s.length() - 1);
        String numStr = s.substring(0, s.length() - 1).trim();
        try {
            n = Long.parseLong(numStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        switch (unit) {
            case 'd': {
                Duration duration = Duration.ofDays(n);
                break;
            }
            case 'h': {
                Duration duration = Duration.ofHours(n);
                break;
            }
            case 'm': {
                Duration duration = Duration.ofMinutes(n);
                break;
            }
            case 's': {
                Duration duration = Duration.ofSeconds(n);
                break;
            }
            default: {
                Duration duration = d = null;
            }
        }
        if (d == null) {
            return null;
        }
        return neg ? d.negated() : d;
    }

    public static String formatHMS(long totalSeconds) {
        if (totalSeconds < 0L) {
            totalSeconds = 0L;
        }
        long days = totalSeconds / 86400L;
        long rem = totalSeconds % 86400L;
        long hours = rem / 3600L;
        long minutes = (rem %= 3600L) / 60L;
        long seconds = rem % 60L;
        if (days > 0L) {
            return String.format("%dd %02d:%02d:%02d", days, hours, minutes, seconds);
        }
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}

