/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.showcase;

import java.time.Duration;
import java.util.Locale;

public enum ShowcaseType {
    ACTIONBAR(Duration.ofSeconds(1L)),
    BOSSBAR(Duration.ofSeconds(1L)),
    TEXT(Duration.ofSeconds(10L)),
    TITLE(Duration.ofSeconds(1L));

    private final Duration defaultInterval;

    private ShowcaseType(Duration defaultInterval) {
        this.defaultInterval = defaultInterval;
    }

    public static ShowcaseType fromKey(String key) {
        if (key == null) {
            return null;
        }
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "actionbar" -> ACTIONBAR;
            case "bossbar" -> BOSSBAR;
            case "text" -> TEXT;
            case "title" -> TITLE;
            default -> null;
        };
    }

    public Duration defaultInterval() {
        return this.defaultInterval;
    }
}

