/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime.showcase;

import java.util.Locale;
import java.util.function.Supplier;
import top.ourisland.invertotimer.config.model.ShowcaseConfig;
import top.ourisland.invertotimer.runtime.RuntimeContext;
import top.ourisland.invertotimer.showcase.ActionbarShowcase;
import top.ourisland.invertotimer.showcase.BossbarShowcase;
import top.ourisland.invertotimer.showcase.Showcase;
import top.ourisland.invertotimer.showcase.TextShowcase;
import top.ourisland.invertotimer.showcase.TitleShowcase;

public final class ShowcaseFactory {
    private ShowcaseFactory() {
    }

    public static Showcase create(String key, ShowcaseConfig sc, RuntimeContext ctx, Supplier<Float> bossbarProgress) {
        if (key == null || sc == null || !sc.enabled()) {
            return null;
        }
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "actionbar" -> new ActionbarShowcase(ctx, sc.text());
            case "text" -> new TextShowcase(ctx, sc.text());
            case "title" -> new TitleShowcase(ctx, sc.text(), sc.subtitle());
            case "bossbar" -> new BossbarShowcase(ctx, sc.text(), bossbarProgress);
            default -> null;
        };
    }
}

