/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.runtime;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import top.ourisland.invertotimer.config.ConfigManager;

public final class I18n {
    private static ResourceBundle bundle;
    private static Logger logger;
    private static ConfigManager configManager;

    private I18n() {
    }

    public static void init(ConfigManager configManager, Logger logger) {
        I18n.configManager = configManager;
        I18n.logger = logger;
        I18n.reload();
    }

    public static void reload() {
        String lang = configManager.getGlobalConfig().lang();
        I18n.loadBundle(lang);
    }

    private static void loadBundle(String lang) {
        try {
            bundle = ResourceBundle.getBundle("lang/" + lang);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle("lang/en_us");
            logger.warn("Failed to load language '{}', fallback to en_us", (Object)lang);
        }
    }

    public static Component lang(String key) {
        return Component.text((String)I18n.langStr(key));
    }

    public static Component lang(String key, Object ... args) {
        return Component.text((String)I18n.langStr(key, args));
    }

    public static Component langNP(String key) {
        return Component.text((String)I18n.langStrNP(key));
    }

    public static Component langNP(String key, Object ... args) {
        return Component.text((String)I18n.langStrNP(key, args));
    }

    public static String langStr(String key) {
        return I18n.prefixStr() + I18n.pattern(key);
    }

    public static String langStr(String key, Object ... args) {
        return I18n.prefixStr() + I18n.format(key, args);
    }

    public static String langStrNP(String key) {
        return I18n.pattern(key);
    }

    public static String langStrNP(String key, Object ... args) {
        return I18n.format(key, args);
    }

    private static String prefixStr() {
        return bundle.getString("itimer.prefix");
    }

    private static String pattern(String key) {
        return bundle.getString(key);
    }

    private static String format(String key, Object ... args) {
        String p = bundle.getString(key);
        return args == null || args.length == 0 ? p : MessageFormat.format(p, args);
    }
}

