/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import top.ourisland.invertotimer.config.SimpleYaml;

public class ServerLimitation {
    private final Mode mode;
    private final Set<String> servers;

    public ServerLimitation(Mode mode, Set<String> servers) {
        this.mode = mode;
        this.servers = servers;
    }

    public static ServerLimitation fromYaml(Object obj) {
        if (!(obj instanceof Map)) {
            return ServerLimitation.allowAll();
        }
        Map m = (Map)obj;
        String modeStr = SimpleYaml.getString(m, "mode", "blacklist");
        Mode mode = "whitelist".equalsIgnoreCase(modeStr) ? Mode.WHITELIST : Mode.BLACKLIST;
        HashSet<String> set = new HashSet<String>();
        Object listObj = m.get("list");
        if (listObj instanceof Collection) {
            Collection c = (Collection)listObj;
            for (Object o : c) {
                set.add(String.valueOf(o).toLowerCase(Locale.ROOT));
            }
        }
        return new ServerLimitation(mode, Set.copyOf(set));
    }

    public static ServerLimitation allowAll() {
        return new ServerLimitation(Mode.BLACKLIST, Set.of());
    }

    public boolean isAllowed(String serverName) {
        if (serverName == null) {
            return true;
        }
        boolean contains = this.servers.contains(serverName.toLowerCase(Locale.ROOT));
        return this.mode == Mode.BLACKLIST != contains;
    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST;

    }
}

