/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config.model;

import java.time.ZoneId;
import java.util.Map;
import top.ourisland.invertotimer.config.SimpleYaml;
import top.ourisland.invertotimer.config.model.ServerLimitation;

public record GlobalConfig(String lang, ZoneId zoneId, ServerLimitation limitation) {
    public static GlobalConfig defaults() {
        return new GlobalConfig("en_us", ZoneId.systemDefault(), ServerLimitation.allowAll());
    }

    public static GlobalConfig fromYaml(Map<?, ?> m) {
        ZoneId zone;
        String lang = SimpleYaml.getString(m, "lang", "en_us");
        String tz = SimpleYaml.getString(m, "timezone", ZoneId.systemDefault().getId());
        try {
            zone = ZoneId.of(tz);
        }
        catch (Exception e) {
            zone = ZoneId.systemDefault();
        }
        ServerLimitation lim = ServerLimitation.fromYaml(m.get("limitation"));
        return new GlobalConfig(lang, zone, lim);
    }
}

