/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.config;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SimpleYaml {
    private SimpleYaml() {
    }

    public static Object parse(String yaml) {
        List<String> lines = yaml.lines().toList();
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        ArrayDeque<Frame> stack = new ArrayDeque<Frame>();
        stack.push(Frame.root(root));
        for (int lineNo = 0; lineNo < lines.size(); ++lineNo) {
            String raw = lines.get(lineNo);
            String line = SimpleYaml.stripComments(raw);
            if (line.isBlank()) continue;
            int indent = SimpleYaml.countIndent(line);
            String trimmed = line.trim();
            while (stack.size() > 1 && indent < ((Frame)stack.peek()).indent) {
                stack.pop();
            }
            if (trimmed.startsWith("- ")) {
                Map m;
                Frame f = (Frame)stack.peek();
                if (f.container instanceof Map && f.parentMap != null && f.parentKey != null && (m = (Map)f.container).isEmpty()) {
                    ArrayList list = new ArrayList();
                    f.parentMap.put(f.parentKey, list);
                    f.container = list;
                }
                if (!(((Frame)stack.peek()).container instanceof List)) {
                    throw new IllegalStateException("List item without list container near line " + (lineNo + 1) + ": " + raw);
                }
                List list = (List)((Frame)stack.peek()).container;
                String item = trimmed.substring(2).trim();
                if (item.contains(":")) {
                    LinkedHashMap<String, Object> mapItem = new LinkedHashMap<String, Object>();
                    SimpleYaml.parseKeyValueIntoMap(mapItem, item);
                    list.add(mapItem);
                    stack.push(new Frame(indent + 2, mapItem, null, null));
                    continue;
                }
                list.add(SimpleYaml.parseScalar(item));
                continue;
            }
            if (!(((Frame)stack.peek()).container instanceof Map)) {
                throw new IllegalStateException("Key-value line under non-map near line " + (lineNo + 1) + ": " + raw);
            }
            Map map = (Map)((Frame)stack.peek()).container;
            int colon = trimmed.indexOf(58);
            if (colon < 0) {
                throw new IllegalStateException("Invalid YAML line " + (lineNo + 1) + ": " + raw);
            }
            String key = trimmed.substring(0, colon).trim();
            String rest = trimmed.substring(colon + 1).trim();
            if (rest.isEmpty()) {
                LinkedHashMap child = new LinkedHashMap();
                map.put(key, child);
                stack.push(new Frame(indent + 2, child, map, key));
                continue;
            }
            map.put(key, SimpleYaml.parseScalar(rest));
        }
        return root;
    }

    private static String stripComments(String raw) {
        boolean inSingle = false;
        boolean inDouble = false;
        StringBuilder sb = new StringBuilder(raw.length());
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c == '\'' && !inDouble) {
                boolean bl = inSingle = !inSingle;
            }
            if (c == '\"' && !inSingle) {
                boolean bl = inDouble = !inDouble;
            }
            if (c == '#' && !inSingle && !inDouble) break;
            sb.append(c);
        }
        return sb.toString();
    }

    private static int countIndent(String s) {
        int n;
        for (n = 0; n < s.length() && s.charAt(n) == ' '; ++n) {
        }
        return n;
    }

    private static void parseKeyValueIntoMap(Map<String, Object> map, String line) {
        int colon = line.indexOf(58);
        String key = line.substring(0, colon).trim();
        String rest = line.substring(colon + 1).trim();
        if (rest.isEmpty()) {
            map.put(key, new LinkedHashMap());
        } else {
            map.put(key, SimpleYaml.parseScalar(rest));
        }
    }

    private static Object parseScalar(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"") && s.length() >= 2) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("'") && s.endsWith("'") && s.length() >= 2) {
            return s.substring(1, s.length() - 1);
        }
        if ("true".equalsIgnoreCase(s)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(s)) {
            return Boolean.FALSE;
        }
        try {
            if (s.contains(".")) {
                return Double.parseDouble(s);
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    public static String getString(Map<?, ?> m, String key, String def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        return v == null ? def : String.valueOf(v);
    }

    public static boolean getBool(Map<?, ?> m, String key, boolean def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return b;
        }
        return Boolean.parseBoolean(String.valueOf(v));
    }

    public static long getLong(Map<?, ?> m, String key, long def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return n.longValue();
        }
        try {
            return Long.parseLong(String.valueOf(v));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static double getDouble(Map<?, ?> m, String key, double def) {
        if (m == null) {
            return def;
        }
        Object v = m.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return n.doubleValue();
        }
        try {
            return Double.parseDouble(String.valueOf(v));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Map<?, ?> getMap(Map<?, ?> m, String key) {
        if (m == null) {
            return Map.of();
        }
        Object v = m.get(key);
        Map<?, ?> mm = SimpleYaml.asMap(v);
        return mm == null ? Map.of() : mm;
    }

    public static Map<?, ?> asMap(Object o) {
        Map m;
        return o instanceof Map ? (m = (Map)o) : null;
    }

    public static List<?> getList(Map<?, ?> m, String key) {
        if (m == null) {
            return List.of();
        }
        Object v = m.get(key);
        List<?> l = SimpleYaml.asList(v);
        return l == null ? List.of() : l;
    }

    public static List<?> asList(Object o) {
        List l;
        return o instanceof List ? (l = (List)o) : null;
    }

    private static final class Frame {
        final int indent;
        final Map<String, Object> parentMap;
        final String parentKey;
        Object container;

        Frame(int indent, Object container, Map<String, Object> parentMap, String parentKey) {
            this.indent = indent;
            this.container = container;
            this.parentMap = parentMap;
            this.parentKey = parentKey;
        }

        static Frame root(Map<String, Object> root) {
            return new Frame(0, root, null, null);
        }
    }
}

