/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.action;

import com.velocitypowered.api.proxy.Player;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;

public class TextAction
implements Action {
    private final RuntimeContext ctx;
    private final TextType textType;
    private final String info;

    public TextAction(RuntimeContext ctx, TextType textType, String info) {
        this.ctx = Objects.requireNonNull(ctx);
        this.textType = Objects.requireNonNull(textType);
        this.info = info == null ? "" : info;
    }

    public static TextType parse(String s) {
        if (s == null) {
            return TextType.MESSAGE;
        }
        return switch (s.toLowerCase(Locale.ROOT)) {
            case "actionbar" -> TextType.ACTIONBAR;
            case "title" -> TextType.TITLE;
            case "subtitle" -> TextType.SUBTITLE;
            default -> TextType.MESSAGE;
        };
    }

    @Override
    public String name() {
        return "text";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.action.text.desc");
    }

    @Override
    public void execute() {
        Component msg = this.ctx.render(this.info);
        for (Player p : this.ctx.players()) {
            if (!this.ctx.allowed(p)) continue;
            switch (this.textType.ordinal()) {
                case 1: {
                    p.sendActionBar(msg);
                    break;
                }
                case 2: {
                    p.showTitle(Title.title((Component)msg, (Component)Component.empty()));
                    break;
                }
                case 3: {
                    p.showTitle(Title.title((Component)Component.empty(), (Component)msg));
                    break;
                }
                case 0: {
                    p.sendMessage(msg);
                }
            }
        }
    }

    public static enum TextType {
        MESSAGE,
        ACTIONBAR,
        TITLE,
        SUBTITLE;

    }
}

