/*
 * Decompiled with CFR 0.152.
 */
package top.ourisland.invertotimer.action;

import com.velocitypowered.api.command.CommandSource;
import java.util.Objects;
import java.util.regex.Pattern;
import top.ourisland.invertotimer.action.Action;
import top.ourisland.invertotimer.runtime.I18n;
import top.ourisland.invertotimer.runtime.RuntimeContext;

public class CommandAction
implements Action {
    private final RuntimeContext ctx;
    private final Executor executor;
    private final String command;
    private final Pattern match;

    public CommandAction(RuntimeContext ctx, Executor executor, String command, String matchRegex) {
        this.ctx = Objects.requireNonNull(ctx);
        this.executor = executor == null ? Executor.PLAYER : executor;
        this.command = command == null ? "" : command;
        Pattern compiled = null;
        if (this.executor == Executor.PLAYER && matchRegex != null && !matchRegex.isBlank()) {
            try {
                compiled = Pattern.compile(matchRegex);
            }
            catch (Exception ignored) {
                compiled = null;
            }
        }
        this.match = compiled;
    }

    public static Executor parse(String s) {
        if (s == null) {
            return Executor.PLAYER;
        }
        return "console".equalsIgnoreCase(s) ? Executor.CONSOLE : Executor.PLAYER;
    }

    @Override
    public String name() {
        return "command";
    }

    @Override
    public String description() {
        return I18n.langStrNP("itimer.action.command.desc");
    }

    @Override
    public void execute() {
        String cmd = this.ctx.renderString(this.command).trim();
        if (cmd.isBlank()) {
            return;
        }
        switch (this.executor.ordinal()) {
            case 0: {
                this.ctx.proxy().getCommandManager().executeAsync((CommandSource)this.ctx.proxy().getConsoleCommandSource(), CommandAction.trimLeadingSlash(cmd));
                break;
            }
            case 1: {
                this.ctx.players().stream().filter(this.ctx::allowed).filter(p -> this.match == null || this.match.matcher(p.getUsername()).matches()).forEach(p -> p.spoofChatInput(cmd));
            }
        }
    }

    private static String trimLeadingSlash(String cmd) {
        String s = cmd.trim();
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public static enum Executor {
        CONSOLE,
        PLAYER;

    }
}

