/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mholloway.displaynames;

import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.mholloway.displaynames.shaded.org.bstats.bukkit.Metrics;

public final class DisplayNames
extends JavaPlugin
implements Listener {
    Metrics metrics;

    public void onEnable() {
        this.metrics = new Metrics(this, 27751);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private Component replaceName(Component oldMessage, Player player) {
        return this.replaceName(oldMessage, player, null);
    }

    private Component replaceName(Component oldMessage, Player player, @Nullable Player player2) {
        if (!(oldMessage instanceof TranslatableComponent)) {
            throw new IllegalArgumentException("Expected TranslatableComponent");
        }
        TranslatableComponent translComponent = (TranslatableComponent)oldMessage;
        List<TranslationArgument> newArgs = translComponent.arguments().stream().map(arg -> {
            Object value = arg.value();
            if (!(value instanceof TextComponent)) {
                return arg;
            }
            TextComponent comp = (TextComponent)value;
            String content = comp.content();
            if (content.equals(player.getName())) {
                return TranslationArgument.component((ComponentLike)player.displayName());
            }
            if (player2 != null && content.equals(player2.getName())) {
                return TranslationArgument.component((ComponentLike)player2.displayName());
            }
            return arg;
        }).toList();
        return translComponent.arguments(newArgs);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        event.joinMessage(this.replaceName(event.joinMessage(), event.getPlayer()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        event.quitMessage(this.replaceName(event.quitMessage(), event.getPlayer()));
    }

    @EventHandler
    public void onAchievement(PlayerAdvancementDoneEvent event) {
        event.message(this.replaceName(event.message(), event.getPlayer()));
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        event.deathMessage(this.replaceName(event.deathMessage(), event.getPlayer(), event.getPlayer().getKiller()));
    }

    @EventHandler
    public void onKill(TameableDeathMessageEvent event) {
        event.deathMessage(this.replaceName(event.deathMessage(), event.getEntity().getKiller()));
    }

    public void onDisable() {
        this.metrics.shutdown();
    }
}

