/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ontey.CustomCommand;
import com.ontey.execution.Execution;
import com.ontey.execution.Formattation;
import com.ontey.files.Config;
import com.ontey.holder.Paths;
import com.ontey.holder.Placeholder;
import com.ontey.log.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import org.bukkit.configuration.file.YamlConfiguration;

public class UrlCall {
    public String url;
    public String userAgent;
    public String jsonPath;
    public String name;
    public CustomCommand after;

    public UrlCall(String commandName, YamlConfiguration config, File file, String name, String url, String userAgent, String jsonPath) {
        this.name = name;
        this.url = url;
        this.userAgent = userAgent;
        this.jsonPath = jsonPath;
        this.after = new CustomCommand(config, file, Paths.UrlCall.after(commandName, name));
    }

    public void execute(Execution exe) {
        try {
            HttpURLConnection conn = (HttpURLConnection)URI.create(Formattation.formattedMessage(this.url, exe)).toURL().openConnection();
            conn.setRequestProperty("User-Agent", Formattation.formattedMessage(this.userAgent, exe));
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String str = this.jsonPath == null ? obj.toString() : obj.get(Formattation.formattedMessage(this.jsonPath, exe)).getAsString();
            this.executeCommand(exe, str);
        }
        catch (MalformedURLException e) {
            Log.info("Malformed URL: " + this.url, "Not running command!");
        }
        catch (IOException ignored) {
            Log.info("Couldn't open / read from the connection. Not running command!");
        }
    }

    private void executeCommand(Execution exe, String result) {
        this.after.storage.add(Config.singletonList(new Placeholder("result", result)));
        this.after.execute(exe.sender, exe.label, exe.args);
    }
}

