/*
 * Decompiled with CFR 0.152.
 */
package com.ontey;

import com.ontey.execution.ConditionParser;
import com.ontey.execution.Execution;
import com.ontey.execution.Formattation;
import com.ontey.files.Config;
import com.ontey.files.Files;
import com.ontey.holder.Paths;
import com.ontey.holder.PlaceholderStorage;
import com.ontey.log.Log;
import com.ontey.tab.Tab;
import com.ontey.types.AdvancedBroadcast;
import com.ontey.types.Args;
import com.ontey.types.UrlCall;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class CustomCommand {
    public static final List<CustomCommand> registeredCommands = new ArrayList<CustomCommand>();
    public List<String> commands;
    public List<String> messages;
    public List<String> broadcasts;
    public List<String> conditions;
    public List<String> conditionErrorMessage;
    @Nullable
    public String permission;
    @Nullable
    public String description;
    @Nullable
    public String usage;
    @Nullable
    public AdvancedBroadcast advancedBroadcast;
    public Args args;
    public Tab tab;
    public List<UrlCall> urlCalls;
    public PlaceholderStorage storage;
    public final String name;
    public final String command;
    public final String namespace;
    public final List<String> aliases;
    public final YamlConfiguration config;
    public final File file;

    public CustomCommand(YamlConfiguration config, File file, String name) {
        this.config = config;
        this.file = file;
        this.name = name;
        this.command = this.getCommandName(name);
        this.namespace = this.getNamespace();
        this.aliases = this.getAliases();
        this.load(false);
    }

    public void execute(CommandSender sender, String label, String[] args) {
        Execution exe = new Execution(this, sender, label, args);
        Formattation formattation = new Formattation(exe);
        if (Config.HOTSWAP) {
            this.load(true);
        }
        formattation.formatCommand();
        if (!this.args.checkArgs(sender, args) || !ConditionParser.evalCommandConditions(exe)) {
            return;
        }
        Log.info(this.args.getRaw().toString());
        exe.runCommands();
        exe.sendMessages();
        exe.sendBroadcasts();
        exe.sendAdvancedBroadcast();
        this.executeUrlCalls(exe);
    }

    public boolean load(boolean reload) {
        if (reload && !this.reloadFile()) {
            return false;
        }
        this.permission = this.getPermission();
        this.description = this.getDescription();
        this.usage = this.getUsage();
        this.messages = this.getMessages();
        this.broadcasts = this.getBroadcasts();
        this.advancedBroadcast = this.getAdvancedBroadcast();
        this.commands = this.getCommands();
        this.args = this.getArgs();
        this.tab = new Tab(this);
        this.conditions = this.getConditions();
        this.conditionErrorMessage = this.getConditionErrorMessage();
        this.storage = new PlaceholderStorage();
        this.urlCalls = this.getUrlCalls();
        return true;
    }

    private boolean reloadFile() {
        try {
            this.config.load(this.file);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void executeUrlCalls(Execution exe) {
        this.urlCalls.forEach(call -> call.execute(exe));
    }

    public String toString() {
        return this.name;
    }

    public String getCommandName(String sectionName) {
        String setName = this.config.getString(Paths.command(sectionName));
        if (setName != null) {
            return setName;
        }
        return sectionName;
    }

    public List<String> getMessages() {
        return Files.getField((ConfigurationSection)this.config, Paths.message(this.name));
    }

    public List<String> getBroadcasts() {
        return Files.getField((ConfigurationSection)this.config, Paths.broadcast(this.name));
    }

    public List<String> getCommands() {
        return Files.getField((ConfigurationSection)this.config, Paths.commands(this.name));
    }

    public List<String> getAliases() {
        return Files.getField((ConfigurationSection)this.config, Paths.aliases(this.name));
    }

    public Args getArgs() {
        return new Args(this);
    }

    @Nullable
    public String getPermission() {
        if (!this.requiresPermission()) {
            return null;
        }
        String value = this.config.getString(Paths.permission(this.name));
        return value != null ? value : Config.defaultPerm(this.name);
    }

    private boolean requiresPermission() {
        return this.config.getBoolean(Paths.permissionRequired(this.name), true);
    }

    public String getDescription() {
        List<String> description = Files.getField((ConfigurationSection)this.config, Paths.description(this.name));
        if (description.isEmpty()) {
            description.addAll(Config.DEFAULT_DESCRIPTION);
        }
        return String.join((CharSequence)"\n", description);
    }

    public String getUsage() {
        List<String> usage = Files.getField((ConfigurationSection)this.config, Paths.usage(this.name));
        if (usage.isEmpty()) {
            usage.addAll(Config.DEFAULT_USAGE);
        }
        return String.join((CharSequence)"\n", usage);
    }

    public AdvancedBroadcast getAdvancedBroadcast() {
        String range = this.config.getString(Paths.AdvancedBroadcast.range(this.name), "-1");
        boolean includeConsole = this.config.getBoolean(Paths.AdvancedBroadcast.includeConsole(this.name), false);
        boolean includeSender = this.config.getBoolean(Paths.AdvancedBroadcast.includeSender(this.name), true);
        List<String> permission = Files.getField((ConfigurationSection)this.config, Paths.AdvancedBroadcast.permission(this.name));
        List<String> broadcast = Files.getField((ConfigurationSection)this.config, Paths.AdvancedBroadcast.broadcast(this.name));
        List<String> condition = Files.getField((ConfigurationSection)this.config, Paths.AdvancedBroadcast.condition(this.name));
        return new AdvancedBroadcast(range, permission, condition, broadcast, includeConsole, includeSender);
    }

    public String getNamespace() {
        return this.config.getString(Paths.namespace(this.name), Config.DEFAULT_NAMESPACE);
    }

    public List<String> getNoTab() {
        Config.NoTab noTabMode;
        Config.NoTab noTab = noTabMode = Config.getNoTab(this.config.getString(Paths.noTab(this.name)));
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NONE", "PLAYERS"}, (Config.NoTab)noTab, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> new ArrayList(0);
            case 1 -> Tab.onlinePlayers();
            case -1 -> Config.noTab();
        };
    }

    public List<String> getConditions() {
        return Files.getField((ConfigurationSection)this.config, Paths.conditions(this.name));
    }

    public List<String> getConditionErrorMessage() {
        return Files.getField((ConfigurationSection)this.config, Paths.conditionErrorMessage(this.name), Config.singletonList(Config.LANGUAGE.COMMAND_CONDITION_ERROR));
    }

    public List<UrlCall> getUrlCalls() {
        List<ConfigurationSection> sections = Files.getSections((ConfigurationSection)this.config, Paths.urlCall(this.name));
        ArrayList<UrlCall> out = new ArrayList<UrlCall>();
        sections.forEach(s -> out.add(this.getUrlCall(s.getName())));
        return out;
    }

    public UrlCall getUrlCall(String name) {
        String url = this.config.getString(Paths.UrlCall.url(this.name, name));
        String userAgent = this.config.getString(Paths.UrlCall.userAgent(this.name, name), "CustomCommandUser");
        String jsonPath = this.config.getString(Paths.UrlCall.jsonPath(this.name, name));
        return new UrlCall(this.name, this.config, this.file, name, url, userAgent, jsonPath);
    }
}

