/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.CustomCommand;
import com.ontey.execution.ConditionParser;
import com.ontey.execution.Formattation;
import com.ontey.types.AdvancedBroadcast;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Execution {
    public CustomCommand cmd;
    public CommandSender sender;
    public String label;
    public String[] args;

    public Execution(CustomCommand cmd, CommandSender sender, String label, String[] args) {
        this.cmd = cmd;
        this.sender = sender;
        this.label = label;
        this.args = args;
    }

    public void sendMessages() {
        Execution.sendMessages(this.cmd.messages, this.sender);
    }

    public void runCommands() {
        for (String cmd : this.cmd.commands) {
            if (cmd == null || cmd.isEmpty()) continue;
            Bukkit.dispatchCommand((CommandSender)this.sender, (String)cmd);
        }
    }

    public void sendBroadcasts() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Execution.sendMessages(this.cmd.broadcasts, (CommandSender)player);
        }
    }

    public void sendAdvancedBroadcast() {
        Location location;
        AdvancedBroadcast abc = this.cmd.advancedBroadcast;
        if (abc == null) {
            return;
        }
        new Formattation(this).formatMessages(abc.broadcast);
        List<String> permission = abc.permission;
        List<String> condition = abc.condition;
        double range = abc.range(this);
        CommandSender commandSender = this.sender;
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            location = p.getLocation();
        } else {
            location = null;
        }
        Location senderLoc = location;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (abc.includeConsole) {
                Execution.sendMessages(abc.broadcast, (CommandSender)Bukkit.getConsoleSender());
            }
            if (!abc.includeSender && player.getName().equals(this.sender.getName()) || permission != null && !this.hasPermissions(player, permission) || !ConditionParser.evalConditions(condition, this) || range != -1.0 && senderLoc != null && (!player.getWorld().equals((Object)senderLoc.getWorld()) || player.getLocation().distance(senderLoc) > range)) continue;
            Execution.sendMessages(abc.broadcast, this.sender);
        }
    }

    public static void sendMessages(List<String> messages, CommandSender sender) {
        for (String msg : messages) {
            sender.sendMessage(Formattation.replaceMM(msg));
        }
    }

    private boolean hasPermissions(Player player, List<String> permissions) {
        for (String perm : permissions) {
            if (player.hasPermission(perm)) continue;
            return false;
        }
        return true;
    }
}

