/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.execution.Execution;
import com.ontey.execution.Formattation;
import com.ontey.execution.Replacement;
import com.ontey.files.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConditionParser {
    public static boolean evalCommandConditions(Execution exe) {
        if (!ConditionParser.evalConditions(exe.cmd.conditions, exe)) {
            ConditionParser.sendConditionErrorMessage(exe);
            return false;
        }
        return true;
    }

    private static void sendConditionErrorMessage(Execution exe) {
        if (exe.cmd.conditionErrorMessage.isEmpty()) {
            return;
        }
        Execution.sendMessages(exe.cmd.conditionErrorMessage, exe.sender);
    }

    public static boolean evalConditions(List<String> conditions, Execution exe) {
        if (conditions.isEmpty()) {
            return true;
        }
        for (String str : conditions) {
            if (ConditionParser.evalCondition(str, exe)) continue;
            return false;
        }
        return true;
    }

    public static boolean evalCondition(String str, Execution exe) {
        if (str == null || str.isBlank()) {
            return true;
        }
        str = str.replace(" ", "");
        str = Replacement.replaceArgs(str, exe.args);
        List<String> parts = ConditionParser.splitOrParts(str = Formattation.formattedMessage(str, exe));
        if (parts.size() > 1) {
            for (String part : parts) {
                if (!ConditionParser.evalCondition(part, exe)) continue;
                return true;
            }
            return false;
        }
        return ConditionParser.evalSingle(parts.getFirst());
    }

    private static List<String> splitOrParts(String str) {
        ArrayList<String> parts = new ArrayList<String>();
        int last = 0;
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) != '|' || str.charAt(i + 1) != '|') continue;
            int bs = 0;
            for (int j = i - 1; j >= 0 && str.charAt(j) == '\\'; --j) {
                ++bs;
            }
            if (bs % 2 != 0) continue;
            parts.add(str.substring(last, i));
            last = i + 2;
            ++i;
        }
        parts.add(str.substring(last));
        return parts;
    }

    private static boolean evalSingle(String expr) {
        String[] ops;
        for (String op : ops = new String[]{"==", "=?=", "!=", "!?=", ">=", "<=", ">", "<"}) {
            Pattern pattern = Pattern.compile(Pattern.quote(op));
            Matcher matcher = pattern.matcher(expr);
            while (matcher.find()) {
                int idx = matcher.start();
                int bs = 0;
                for (int i = idx - 1; i >= 0 && expr.charAt(i) == '\\'; --i) {
                    ++bs;
                }
                if (bs % 2 == 1) continue;
                return ConditionParser.findAndCompare(expr, idx, op);
            }
        }
        return ConditionParser.resolveInverted(expr.toLowerCase());
    }

    private static boolean resolveInverted(String expr) {
        if (expr.startsWith("\\!")) {
            return Config.isTrue(expr.substring(1));
        }
        if (expr.startsWith("!")) {
            return !Config.isTrue(expr.substring(1));
        }
        return Config.isTrue(expr);
    }

    private static boolean findAndCompare(String expr, int idx, String op) {
        String left = expr.substring(0, idx);
        String right = expr.substring(idx + op.length());
        left = left.replace("\\\\" + op, op);
        right = right.replace("\\\\" + op, op);
        return ConditionParser.compare(left, right, op);
    }

    private static boolean compare(String left, String right, String op) {
        boolean isNumber;
        boolean bl = isNumber = ConditionParser.isNumeric(left) && ConditionParser.isNumeric(right);
        if (isNumber) {
            double l = Double.parseDouble(left);
            double r = Double.parseDouble(right);
            return switch (op) {
                case "==", "=?=" -> {
                    if (l == r) {
                        yield true;
                    }
                    yield false;
                }
                case "!=", "!?=" -> {
                    if (l != r) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (l > r) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (l < r) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (l >= r) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (l <= r) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return switch (op) {
            case "==" -> left.equals(right);
            case "!=" -> {
                if (!left.equals(right)) {
                    yield true;
                }
                yield false;
            }
            case "=?=" -> left.equalsIgnoreCase(right);
            case "!?=" -> {
                if (!left.equalsIgnoreCase(right)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    static List<String> resolveConditions(List<String> commands, Execution exe) {
        if (commands.isEmpty()) {
            return commands;
        }
        String prefix = Config.ph("condition");
        for (int i = 0; i < commands.size(); ++i) {
            String line = commands.get(i);
            if (line.startsWith(prefix)) {
                int start = i;
                boolean allTrue = true;
                while (i < commands.size() && commands.get(i).startsWith(prefix)) {
                    String condLine = commands.get(i).substring(prefix.length());
                    boolean result = ConditionParser.evalCondition(condLine, exe);
                    commands.remove(i);
                    if (result) continue;
                    allTrue = false;
                }
                if (!allTrue && i < commands.size()) {
                    commands.remove(i);
                }
                i = start - 1;
                continue;
            }
            if (!line.startsWith("\\" + prefix)) continue;
            commands.set(i, line.substring(1));
        }
        return commands;
    }

    static String str(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("[+-]?\\d+(\\.\\d+)?");
    }
}

